/*
 * Decompiled with CFR 0.152.
 */
package jhpro.tseries;

import org.apache.commons.math3.util.FastMath;

public class GaussianFilter {
    private static final double a = 0.93911;
    private static final double b = 2.77066;
    static final double SIGMA_TO_FWHM = 2.354;
    private double[] inSpectrum;
    private double[] outSpectrum;
    private double width;

    public GaussianFilter(double[] inSpectrum, double width) {
        this.inSpectrum = inSpectrum;
        this.width = width;
        this.processSpectrum();
    }

    private void processSpectrum() {
        int length = this.inSpectrum.length;
        this.outSpectrum = new double[length];
        for (int newChannel = 0; newChannel < length; ++newChannel) {
            double newCounts = 0.0;
            double scaleFactor = 0.93911 * this.inSpectrum[newChannel] / this.width;
            int minCh = (int)FastMath.round((double)FastMath.max((double)0.0, (double)((double)newChannel - 3.0 * this.width)));
            int maxCh = (int)FastMath.round((double)FastMath.min((double)(length - 1), (double)((double)newChannel + 3.0 * this.width)));
            for (int oldChannel = minCh; oldChannel <= maxCh; ++oldChannel) {
                newCounts += FastMath.exp((double)(-2.77066 * FastMath.pow((double)((double)(oldChannel - newChannel) / this.width), (int)2)));
            }
            this.outSpectrum[newChannel] = newCounts *= scaleFactor;
        }
    }

    public double[] getFilteredSpectrum() {
        return this.outSpectrum;
    }
}

