/*
 * Decompiled with CFR 0.152.
 */
package jhpro.stat;

import jhplot.P1D;
import jhplot.gui.HelpBrowser;
import org.apache.commons.math3.util.FastMath;

public class MomentsNorm {
    private int oder = 0;
    private double[] IL;
    private double[] IE;
    private double[] IEE;
    private double[] VAL;
    private double[] AVAL;
    private int nev = 0;

    public MomentsNorm(int order) {
        this.oder = order;
        this.IL = new double[this.oder];
        this.IE = new double[this.oder];
        this.IEE = new double[this.oder];
        this.VAL = new double[this.oder];
        this.AVAL = new double[this.oder];
        for (int i = 0; i < this.oder; ++i) {
            this.IL[i] = 0.0;
            this.IE[i] = 0.0;
            this.IEE[i] = 0.0;
            this.VAL[i] = 0.0;
            this.AVAL[i] = 0.0;
        }
    }

    public void process(int n) {
        ++this.nev;
        for (int i = 0; i < this.oder; ++i) {
            int h = n;
            for (int j = 0; j < i; ++j) {
                h *= n;
            }
            this.IL[i] = this.IL[i] + (double)h;
            this.IE[i] = this.IE[i] + (double)(h * h);
            this.IEE[i] = this.IEE[i] + (double)(h * n);
        }
    }

    public double[] getValues() {
        int i;
        double events = this.nev - 1;
        for (i = 0; i < this.oder; ++i) {
            this.AVAL[i] = this.IL[i] / events;
        }
        for (i = 0; i < this.oder; ++i) {
            this.VAL[i] = this.AVAL[i] / FastMath.pow((double)this.AVAL[0], (int)(i + 1));
        }
        return this.VAL;
    }

    public double[] getErrors() {
        double events = this.nev - 1;
        double[] IER = new double[this.oder];
        for (int i = 0; i < this.oder; ++i) {
            double X1 = this.IL[i] / events;
            double X2 = this.IE[i] / events;
            double VAR = X2 - X1 * X1;
            IER[i] = 0.0;
            if (!(VAR > 0.0)) continue;
            IER[i] = VAR / events;
        }
        double[] COV = new double[this.oder];
        for (int i = 0; i < this.oder; ++i) {
            double x1 = this.IEE[i] / events;
            double x2 = this.IL[i] / events * (this.IL[0] / events);
            COV[i] = (x1 - x2) / events;
        }
        double[] ERROR = new double[this.oder];
        for (int i = 0; i < this.oder; ++i) {
            int n = i + 1;
            double x1 = IER[i] / FastMath.pow((double)this.AVAL[0], (int)(2 * n));
            double x2 = (double)(n * n) * (this.AVAL[i] * this.AVAL[i] / FastMath.pow((double)this.AVAL[0], (int)(2 * n + 2))) * IER[0];
            double x3 = (double)(2 * n) * (this.AVAL[i] / FastMath.pow((double)this.AVAL[0], (int)(2 * n + 1))) * COV[i];
            double VARTOT = x1 + x2 - x3;
            ERROR[i] = 0.0;
            if (!(VARTOT > 0.0)) continue;
            ERROR[i] = FastMath.sqrt((double)VARTOT);
        }
        return ERROR;
    }

    public P1D getResults() {
        P1D tmp = new P1D("Factorial Moments");
        double[] val = this.getValues();
        double[] err = this.getErrors();
        for (int i = 0; i < this.oder; ++i) {
            tmp.add(i + 1, val[i], err[i]);
        }
        return tmp;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

