/*
 * Decompiled with CFR 0.152.
 */
package jhpro.stat;

import java.io.Serializable;
import java.util.ArrayList;
import jhplot.H1D;
import jhplot.P1D;
import jhpro.stat.DataKeeper;

public class DataSource
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<DataKeeper> fSignal;
    private ArrayList<DataKeeper> fBackground;
    private ArrayList<DataKeeper> fCandidates;
    private ArrayList<Double> fErrorOnSignal;
    private ArrayList<Double> fErrorOnBackground;
    private ArrayList<Double> fErrorOnData;
    private ArrayList<String> fIds;
    private static int chenCounter = 0;

    public DataSource() {
        chenCounter = 0;
        this.SetOwner();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public DataSource(H1D s, H1D b, H1D d) {
        chenCounter = 0;
        this.SetOwner();
        this.addChannel(s, b, d, 0.0, 0.0, 0.0, "ch" + Integer.toString(chenCounter));
    }

    public DataSource(P1D s, P1D b, P1D d) {
        chenCounter = 0;
        this.SetOwner();
        this.addChannel(s, b, d, 0.0, 0.0, 0.0, "ch" + Integer.toString(chenCounter));
    }

    public DataSource(H1D s, H1D b, H1D d, double es, double eb, double ed, String name) {
        chenCounter = 0;
        this.SetOwner();
        this.addChannel(s, b, d, es, eb, ed, name);
    }

    public void addChannel(H1D s, H1D b, H1D d) {
        DataKeeper ss = new DataKeeper(s);
        DataKeeper bb = new DataKeeper(b);
        DataKeeper dd = new DataKeeper(d);
        this.addChannel(ss, bb, dd, 0.0, 0.0, 0.0, "ch" + Integer.toString(++chenCounter));
    }

    public void addChannel(P1D s, P1D b, P1D d) {
        DataKeeper ss = new DataKeeper(s);
        DataKeeper bb = new DataKeeper(b);
        DataKeeper dd = new DataKeeper(d);
        this.addChannel(ss, bb, dd, 0.0, 0.0, 0.0, "ch" + Integer.toString(++chenCounter));
    }

    public void addChannel(DataKeeper s, DataKeeper b, DataKeeper d, double es, double eb, double ed, String name) {
        ++chenCounter;
        this.fSignal.add(s);
        this.fBackground.add(b);
        this.fCandidates.add(d);
        this.fErrorOnSignal.add(es);
        this.fErrorOnBackground.add(eb);
        this.fErrorOnData.add(ed);
        this.fIds.add(name);
    }

    public void addChannel(DataKeeper s, DataKeeper b, DataKeeper d) {
        this.addChannel(s, b, d, 0.0, 0.0, 0.0, "ch" + Integer.toString(++chenCounter));
    }

    public ArrayList<DataKeeper> getSignal() {
        return this.fSignal;
    }

    public ArrayList<DataKeeper> getBackground() {
        return this.fBackground;
    }

    public ArrayList<DataKeeper> getCandidates() {
        return this.fCandidates;
    }

    public ArrayList<Double> getErrorOnSignal() {
        return this.fErrorOnSignal;
    }

    public ArrayList<Double> getErrorOnBackground() {
        return this.fErrorOnBackground;
    }

    public ArrayList<Double> getErrorOnData() {
        return this.fErrorOnData;
    }

    public ArrayList<String> getErrorNames() {
        return this.fIds;
    }

    public void addChannel(H1D s, H1D b, H1D d, double es, double eb, double ed, String name) {
        ++chenCounter;
        DataKeeper ss = new DataKeeper(s);
        DataKeeper bb = new DataKeeper(b);
        DataKeeper dd = new DataKeeper(d);
        this.addChannel(ss, bb, dd, es, eb, ed, name);
    }

    public void addChannel(P1D s, P1D b, P1D d, double es, double eb, double ed, String name) {
        ++chenCounter;
        DataKeeper ss = new DataKeeper(s);
        DataKeeper bb = new DataKeeper(b);
        DataKeeper dd = new DataKeeper(d);
        this.addChannel(ss, bb, dd, es, eb, ed, name);
    }

    public int getNumberChennels() {
        return chenCounter;
    }

    public void SetOwner() {
        this.fSignal = new ArrayList();
        this.fBackground = new ArrayList();
        this.fCandidates = new ArrayList();
        this.fErrorOnSignal = new ArrayList();
        this.fErrorOnBackground = new ArrayList();
        this.fErrorOnData = new ArrayList();
        this.fIds = new ArrayList();
    }
}

