/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet.jknnl;

import jhpro.nnet.jknnl.MetricModel;
import org.apache.commons.math3.util.FastMath;

public class MinkowskiMetric
implements MetricModel {
    private double p = 1.0;

    public MinkowskiMetric(double p) {
        this.p = p;
    }

    public void setParameteres(double[] paramateresList) {
        this.p = paramateresList[0];
    }

    public double[] getParamateres() {
        double[] parameter = new double[]{this.p};
        return parameter;
    }

    @Override
    public double getDistance(double[] firstVector, double[] secondVector) {
        double distance = 0.0;
        double x = 0.0;
        double w = 0.0;
        double sum = 0.0;
        int weightLenght = firstVector.length;
        if (firstVector.length != secondVector.length) {
            return -1.0;
        }
        for (int i = 0; i < weightLenght; ++i) {
            w = firstVector[i];
            x = secondVector[i];
            sum += FastMath.pow((double)Math.abs(x - w), (double)this.p);
        }
        distance = FastMath.pow((double)sum, (double)(1.0 / this.p));
        return distance;
    }
}

