/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet.jknnl;

import java.util.ArrayList;
import java.util.TreeMap;
import jhpro.nnet.jknnl.Coords;
import jhpro.nnet.jknnl.TopologyModel;

public class MatrixTopology
implements TopologyModel {
    private int colNumber;
    private int rowNumber;
    private int radius = 0;

    public MatrixTopology(int row, int col) {
        this.rowNumber = row;
        this.colNumber = col;
    }

    public MatrixTopology(int row, int col, int radius) {
        this(row, col);
        this.radius = radius;
    }

    @Override
    public String toString() {
        ArrayList tempList = new ArrayList();
        String conn = "";
        for (int i = 1; i < this.colNumber * this.rowNumber + 1; ++i) {
            tempList = this.getConnectedNeurons(i);
            conn = conn + "Neuron number " + i + " is connected with: " + tempList + "\n";
        }
        return conn;
    }

    @Override
    public int getColNumber() {
        return this.colNumber;
    }

    @Override
    public ArrayList getConnectedNeurons(int neuronNumber) {
        ArrayList<Integer> connectedNeurons = new ArrayList<Integer>();
        if (neuronNumber < this.colNumber * this.rowNumber && neuronNumber > 0) {
            if (neuronNumber - this.colNumber > 0) {
                connectedNeurons.add(neuronNumber - this.colNumber);
            }
            if (neuronNumber - 1 > 0 && neuronNumber % this.colNumber != 1) {
                connectedNeurons.add(neuronNumber - 1);
            }
            if (neuronNumber + 1 <= this.colNumber * this.rowNumber && neuronNumber % this.colNumber != 0) {
                connectedNeurons.add(neuronNumber + 1);
            }
            if (neuronNumber + this.colNumber <= this.colNumber * this.rowNumber) {
                connectedNeurons.add(neuronNumber + this.colNumber);
            }
        }
        return connectedNeurons;
    }

    private ArrayList getN(ArrayList tempConnection) {
        ArrayList neighborgoodConn = new ArrayList();
        ArrayList tempConn = new ArrayList();
        for (int j = 0; j < tempConnection.size(); ++j) {
            tempConn = this.getConnectedNeurons((Integer)tempConnection.get(j));
            for (int i = 0; i < tempConn.size(); ++i) {
                neighborgoodConn.add(tempConn.get(i));
            }
        }
        return neighborgoodConn;
    }

    @Override
    public TreeMap getNeighbourhood(int neuronNumber) {
        TreeMap<Integer, Integer> neighbornhood = new TreeMap<Integer, Integer>();
        ArrayList tempConnection = new ArrayList();
        ArrayList neighborgoodConn = new ArrayList();
        tempConnection.add(neuronNumber);
        Object temp = null;
        for (int i = 0; i < this.radius; ++i) {
            neighborgoodConn = this.getN(tempConnection);
            for (int k = 0; k < neighborgoodConn.size(); ++k) {
                int key = (Integer)neighborgoodConn.get(k);
                if (neighbornhood.containsKey(key) || key == neuronNumber) continue;
                neighbornhood.put(key, i + 1);
            }
            tempConnection = (ArrayList)neighborgoodConn.clone();
        }
        return neighbornhood;
    }

    @Override
    public Coords getNeuronCoordinate(int neuronNumber) {
        int x = (neuronNumber - 1) / this.colNumber + 1;
        int y = neuronNumber - (x - 1) * this.colNumber;
        return new Coords(x, y);
    }

    @Override
    public int getNeuronNumber(Coords coords) {
        if (coords.x < this.rowNumber && coords.y < this.colNumber) {
            return (coords.x - 1) * this.colNumber + coords.y;
        }
        return -1;
    }

    @Override
    public int getNumbersOfNeurons() {
        return this.colNumber * this.rowNumber;
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public int getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public void setColNumber(int colNumber) {
        this.colNumber = colNumber;
    }

    @Override
    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }
}

