/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet;

import java.awt.Point;
import jhpro.nnet.Point3D;

public class ThreeD {
    final int tableSize = 512;
    final int angleShift = 9;
    final int maxAngle = 511;
    int[] sinTable;
    int[] cosTable;
    int xSize;
    int ySize;
    int zSize;
    int midX;
    int midY;
    int eyeX;
    int eyeY;
    int eyeZ;
    int xAngle;
    int yAngle;
    int zAngle;
    int xAngleStep;
    int yAngleStep;
    int zAngleStep;

    public ThreeD(int i, int j, int k, int l, int i1) {
        this.xSize = k;
        this.ySize = l;
        this.zSize = i1;
        this.midX = i / 2;
        this.midY = j / 2;
        this.computeSinCosTables();
        this.setEyePosition(0, 0, -500);
        this.setAngles(0, 0, 0);
    }

    void computeSinCosTables() {
        this.sinTable = new int[512];
        this.cosTable = new int[512];
        for (int i = 0; i < 512; ++i) {
            double d = (double)i * Math.PI / 256.0;
            this.sinTable[i] = (int)Math.round(Math.sin(d) * 512.0 + 0.5);
            this.cosTable[i] = (int)Math.round(Math.cos(d) * 512.0 + 0.5);
        }
    }

    public void setEyePosition(int i, int j, int k) {
        this.eyeX = i;
        this.eyeY = j;
        this.eyeZ = k;
    }

    public void setAngles(int i, int j, int k) {
        this.xAngle = i < 0 || i > 511 ? 0 : i;
        this.yAngle = j < 0 || j > 511 ? 0 : j;
        this.zAngle = k < 0 || k > 511 ? 0 : k;
    }

    public void setAngleSteps(int i, int j, int k) {
        this.xAngleStep = Math.abs(i) >= 51 ? 0 : i;
        this.yAngleStep = Math.abs(j) >= 51 ? 0 : j;
        this.zAngleStep = Math.abs(k) >= 51 ? 0 : k;
    }

    public int changeAngle(int i, int j) {
        i = j >= 0 ? (i > 511 - j ? 511 + j - i : i + j) : (i < Math.abs(j) ? 511 + j : i + j);
        return i;
    }

    public void changeAngles() {
        this.xAngle = this.changeAngle(this.xAngle, this.xAngleStep);
        this.yAngle = this.changeAngle(this.yAngle, this.yAngleStep);
        this.zAngle = this.changeAngle(this.zAngle, this.zAngleStep);
    }

    public Point[] rotate3Dto2D(Point3D[] apoint3d) {
        Point[] apoint = new Point[apoint3d.length];
        int k1 = this.sinTable[this.xAngle];
        int l1 = this.sinTable[this.yAngle];
        int i2 = this.sinTable[this.zAngle];
        int j2 = this.cosTable[this.xAngle];
        int k2 = this.cosTable[this.yAngle];
        int l2 = this.cosTable[this.zAngle];
        for (int i3 = 0; i3 < apoint3d.length; ++i3) {
            int l = apoint3d[i3].x;
            int i1 = apoint3d[i3].y;
            int j1 = apoint3d[i3].z;
            int i = l * k2 + j1 * l1 >> 9;
            int k = j1 * k2 - l * l1 >> 9;
            l = i;
            j1 = k;
            int j = i1 * l2 - j1 * i2 >> 9;
            k = i1 * i2 + j1 * l2 >> 9;
            i1 = j;
            j1 = k;
            i = l * j2 - i1 * k1 >> 9;
            j = l * k1 + i1 * j2 >> 9;
            l = i;
            i1 = j;
            i = this.midX;
            j = this.midY;
            if (this.eyeZ != j1) {
                double d = (double)this.eyeZ / ((double)this.eyeZ - (double)j1);
                if (l != 0) {
                    i = (int)((double)i + d * (double)l);
                }
                if (i1 != 0) {
                    j = (int)((double)j + d * (double)i1);
                }
            }
            apoint[i3] = new Point(i, j);
        }
        return apoint;
    }

    public Point3D[] rotate3DPoint(Point3D[] apoint3d) {
        Point3D[] apoint3d1 = new Point3D[apoint3d.length];
        for (int k1 = 0; k1 < apoint3d.length; ++k1) {
            int l = apoint3d[k1].x;
            int i1 = apoint3d[k1].y;
            int j1 = apoint3d[k1].z;
            int i = l * this.cosTable[this.yAngle] + j1 * this.sinTable[this.yAngle] >> 9;
            int k = j1 * this.cosTable[this.yAngle] - l * this.sinTable[this.yAngle] >> 9;
            l = i;
            j1 = k;
            int j = i1 * this.cosTable[this.zAngle] - j1 * this.sinTable[this.zAngle] >> 9;
            k = i1 * this.sinTable[this.zAngle] + j1 * this.cosTable[this.zAngle] >> 9;
            i1 = j;
            j1 = k;
            i = l * this.cosTable[this.xAngle] - i1 * this.sinTable[this.xAngle] >> 9;
            j = l * this.sinTable[this.xAngle] + i1 * this.cosTable[this.xAngle] >> 9;
            l = i;
            i1 = j;
            apoint3d1[k1] = new Point3D(l, i1, j1);
        }
        return apoint3d1;
    }

    public Point[] setPerspective(Point3D[] apoint3d) {
        Point[] apoint = new Point[apoint3d.length];
        int i = this.midX;
        int k = this.midY;
        for (int i1 = 0; i1 < apoint3d.length; ++i1) {
            int j = this.midX;
            int l = this.midY;
            if (this.eyeZ != apoint3d[i1].z) {
                double d = (double)this.eyeZ / ((double)this.eyeZ - (double)apoint3d[i1].z);
                if (apoint3d[i1].x != 0) {
                    j = (int)((double)j + d * (double)apoint3d[i1].x);
                }
                if (apoint3d[i1].y != 0) {
                    l = (int)((double)l + d * (double)apoint3d[i1].y);
                }
            }
            apoint[i1] = new Point(j, l);
        }
        return apoint;
    }

    public Point3D rotate3DPoint(Point3D point3d) {
        int l = point3d.x;
        int i1 = point3d.y;
        int j1 = point3d.z;
        int i = l * this.cosTable[this.yAngle] + j1 * this.sinTable[this.yAngle] >> 9;
        int k = j1 * this.cosTable[this.yAngle] - l * this.sinTable[this.yAngle] >> 9;
        l = i;
        j1 = k;
        int j = i1 * this.cosTable[this.zAngle] - j1 * this.sinTable[this.zAngle] >> 9;
        k = i1 * this.sinTable[this.zAngle] + j1 * this.cosTable[this.zAngle] >> 9;
        i1 = j;
        j1 = k;
        i = l * this.cosTable[this.xAngle] - i1 * this.sinTable[this.xAngle] >> 9;
        j = l * this.sinTable[this.xAngle] + i1 * this.cosTable[this.xAngle] >> 9;
        l = i;
        i1 = j;
        return new Point3D(l, i1, j1);
    }

    public Point setPerspective(Point3D point3d) {
        int i = this.midX;
        int j = this.midY;
        if (this.eyeZ != point3d.z) {
            double d = (double)this.eyeZ / ((double)this.eyeZ - (double)point3d.z);
            if (point3d.x != 0) {
                i = (int)((double)i + d * (double)point3d.x);
            }
            if (point3d.y != 0) {
                j = (int)((double)j + d * (double)point3d.y);
            }
        }
        return new Point(i, j);
    }
}

