/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet;

import java.io.Serializable;

public class Neuron
implements Serializable {
    float input;
    float output;
    float outputError;

    public Neuron() {
        this.init(0.0f);
    }

    public void init(float f) {
        this.input = f;
        this.output = f;
        this.outputError = 0.0f;
    }

    public void computeInput(float[] af, float[] af1) {
        this.input = 0.0f;
        for (int i = 0; i < af.length; ++i) {
            if (af[i] == 0.0f || af1[i] == 0.0f) continue;
            this.input += af[i] * af1[i];
        }
        this.input += af1[af1.length - 1];
    }

    public void activateSigmoid() {
        this.output = 1.0f / (1.0f + (float)Math.exp(-this.input));
    }

    public void computeOutputError(float f) {
        if (this.output != 0.0f && this.output != 1.0f) {
            this.outputError = (f - this.output) * this.output * (1.0f - this.output);
        }
    }

    public void computeOutputError(float[] af, float[] af1) {
        this.outputError = 0.0f;
        for (int i = 0; i < af.length; ++i) {
            if (af[i] == 0.0f || this.output == 0.0f || this.output == 1.0f) continue;
            this.outputError += af[i] * af1[i] * this.output * (1.0f - this.output);
        }
    }

    public float getInput() {
        return this.input;
    }

    public float getOutput() {
        return this.output;
    }

    public float getOutputError() {
        return this.outputError;
    }
}

