/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet;

import jhpro.nnet.InputMatrix;
import jhpro.nnet.InputValue;
import jhpro.nnet.MapNeuron;
import jhpro.nnet.NeuralNet;
import jhpro.nnet.NeuronLayer;
import jhpro.nnet.NeuronMatrix;
import jhpro.nnet.WeightMatrix;

public class KohonenFeatureMap
extends NeuralNet {
    NeuronMatrix mapLayer;
    NeuronLayer inputLayer;
    WeightMatrix weightMatrix;
    InputMatrix inputMatrix;
    InputValue[] iv;
    int xSize;
    int ySize;
    double activationArea;
    double stopArea;
    double initActivationArea;
    double initLearningRate;

    public KohonenFeatureMap() {
        this.learningCycle = 0;
        this.maxLearningCycles = -1;
        this.learningRate = this.initLearningRate = 0.6;
        this.activationArea = this.initActivationArea = this.xSize < this.ySize ? (double)(this.ySize / 2) : (double)(this.xSize / 2);
        this.stopArea = this.initActivationArea / 10.0;
        this.stopLearning = false;
        this.resetTime();
    }

    public void createMapLayer(int i) {
        if (this.mapLayer != null) {
            this.mapLayer = null;
        }
        this.mapLayer = new NeuronMatrix(i);
        this.xSize = i;
        this.ySize = 0;
    }

    public void createMapLayer(int i, int j) {
        if (this.mapLayer != null) {
            this.mapLayer = null;
        }
        this.mapLayer = new NeuronMatrix(i, j);
        this.xSize = i;
        this.ySize = j;
    }

    public void connectLayers(InputMatrix inputmatrix) {
        this.inputMatrix = inputmatrix;
        if (this.inputLayer != null) {
            this.inputLayer = null;
        }
        this.inputLayer = new NeuronLayer(inputmatrix.getDimension());
        int i = this.mapLayer.size();
        if (this.weightMatrix != null) {
            this.weightMatrix = null;
        }
        this.weightMatrix = new WeightMatrix(this.inputLayer.size(), i, false);
        if (this.iv != null) {
            this.iv = null;
        }
        this.iv = new InputValue[i];
        for (int j = 0; j < this.iv.length; ++j) {
            this.iv[j] = inputmatrix.getRandomInput();
        }
        this.weightMatrix.init(this.iv, inputmatrix.getDimension());
        this.mapLayer.init(this.iv);
    }

    public void setInitLearningRate(double d) {
        this.initLearningRate = d;
        this.learningRate = d;
    }

    public double getInitLearningRate() {
        return this.initLearningRate;
    }

    public void setInitActivationArea(double d) {
        this.initActivationArea = d;
        this.activationArea = d;
    }

    public double getInitActivationArea() {
        return this.initActivationArea;
    }

    public void setActivationArea(double d) {
        this.activationArea = d;
    }

    public void setStopArea(double d) {
        this.stopArea = d;
    }

    public double getStopArea() {
        return this.stopArea;
    }

    public double getActivationArea() {
        return this.activationArea;
    }

    public int getMapSizeX() {
        return this.xSize;
    }

    public int getMapSizeY() {
        return this.ySize;
    }

    public int getNumberOfWeights() {
        return this.weightMatrix.size();
    }

    public float[][] getWeightValues() {
        return this.weightMatrix.getWeights();
    }

    public MapNeuron[] getMapNeurons() {
        return this.mapLayer.getMapNeurons();
    }

    public InputValue[] getInputValues() {
        return this.inputMatrix.getInputValues();
    }

    public void decreaseActivationArea() {
        double d = (double)this.learningCycle * 2.0E-4;
        this.setLearningRate(this.initLearningRate * Math.exp(-2.0 * d));
        this.setActivationArea(this.initActivationArea * Math.exp(-5.0 * d));
    }

    public void learn() {
        if (this.activationArea > this.stopArea && (this.learningCycle < this.maxLearningCycles || this.maxLearningCycles == -1)) {
            ++this.learningCycle;
            this.inputLayer.setInput(this.inputMatrix.getRandomInput());
            MapNeuron mapneuron = this.mapLayer.computeActivationCenter(this.inputLayer, this.weightMatrix);
            this.weightMatrix.changeWeightsKFM(this.inputLayer.getOutput(), this.mapLayer.getFeedback(mapneuron, this.activationArea), this.learningRate);
            this.decreaseActivationArea();
            return;
        }
        this.stopLearning = true;
    }
}

