/*
 * Decompiled with CFR 0.152.
 */
package jhpro.fit;

import Jama.Matrix;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import jhplot.P1D;
import jhplot.gui.HelpBrowser;
import jhplot.shapes.Circle;
import jhpro.fit.LineUtil;

public class FitCircle2D {
    private static final int dim = 4;
    private final double distance;
    private Point2D.Double center;
    private Double radius;
    private Double startAngle;
    private Double stopAngle;
    private CubicCurve2D.Double curve;
    private double xMax = Double.MIN_VALUE;
    private double yMax = Double.MIN_VALUE;
    private double xMin = Double.MAX_VALUE;
    private double yMin = Double.MAX_VALUE;

    public FitCircle2D(double[] x, double[] y) {
        this.fit(x, y);
        this.computeAngles(x, y);
        this.distance = this.computeDistance(x, y);
    }

    public FitCircle2D(P1D p) {
        this(p.getArrayX(), p.getArrayY());
    }

    public FitCircle2D(Point2D left, Point2D middle, Point2D right, double[] x, double[] y) {
        this.defineCircle(left, middle, right);
        this.computeAngles(x, y);
        this.distance = this.computeDistance(x, y);
    }

    public Point2D.Double getCenter() {
        return this.center;
    }

    public CubicCurve2D.Double getCurve() {
        if (this.curve == null) {
            this.computeCurve();
        }
        return this.curve;
    }

    public double getDistance() {
        return this.distance;
    }

    public Double getRadius() {
        return this.radius;
    }

    public Double getStartAngle() {
        return this.startAngle;
    }

    public Double getStopAngle() {
        return this.stopAngle;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{Circle");
        sb.append(String.format(" dist=%g", this.distance));
        sb.append(String.format(" center[%g,%g]", this.center.x, this.center.y));
        sb.append(String.format(" radius=%g", this.radius));
        if (this.startAngle != null && this.stopAngle != null) {
            sb.append(String.format(" angles=(%g,%g)", Math.toDegrees(this.startAngle), Math.toDegrees(this.stopAngle)));
        }
        sb.append("}");
        return sb.toString();
    }

    private void computeAngles(double[] x, double[] y) {
        int emptyIdx;
        int BUCKET_NB = 8;
        int[] buckets = new int[8];
        for (int i = 0; i < 8; ++i) {
            buckets[i] = 0;
        }
        double bucketSize = 0.7853981633974483;
        ArrayList<Double> angles = new ArrayList<Double>();
        for (int i = 0; i < x.length; ++i) {
            double angle = Math.PI + Math.atan2(y[i] - this.center.y, x[i] - this.center.x);
            angles.add(angle);
            int idx = (int)(angle / 0.7853981633974483);
            if (idx < 0 || idx >= 8) continue;
            int n = idx;
            buckets[n] = buckets[n] + 1;
        }
        for (emptyIdx = 0; emptyIdx < 8 && buckets[emptyIdx] != 0; ++emptyIdx) {
        }
        if (emptyIdx < 8) {
            double bottom = (double)emptyIdx * 0.7853981633974483;
            double start = Math.PI * 2;
            double stop = 0.0;
            Iterator iterator = angles.iterator();
            while (iterator.hasNext()) {
                double angle = (Double)iterator.next();
                if ((angle -= bottom) < 0.0) {
                    angle += Math.PI * 2;
                }
                if (angle < start) {
                    start = angle;
                }
                if (!(angle > stop)) continue;
                stop = angle;
            }
            if ((stop += bottom - Math.PI) < (start += bottom - Math.PI)) {
                stop += Math.PI * 2;
            }
            this.startAngle = start;
            this.stopAngle = stop;
        }
    }

    private void computeCurve() {
        if (this.stopAngle == null || this.stopAngle.isNaN() || this.startAngle == null || this.startAngle.isNaN()) {
            return;
        }
        double arc = this.stopAngle - this.startAngle;
        double x0 = Math.cos(arc / 2.0);
        double y0 = Math.sin(arc / 2.0);
        double x1 = (4.0 - x0) / 3.0;
        double y1 = (1.0 - x0) * (3.0 - x0) / (3.0 * y0);
        double x2 = x1;
        double y2 = -y1;
        double x3 = x0;
        double y3 = -y0;
        double theta = (this.startAngle + this.stopAngle) / 2.0;
        Matrix rotation = new Matrix((double[][])new double[][]{{Math.cos(theta), -Math.sin(theta), 0.0}, {Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
        Matrix scaling = new Matrix((double[][])new double[][]{{this.radius, 0.0, 0.0}, {0.0, this.radius, 0.0}, {0.0, 0.0, 1.0}});
        Matrix translation = new Matrix((double[][])new double[][]{{1.0, 0.0, this.center.x}, {0.0, 1.0, this.center.y}, {0.0, 0.0, 1.0}});
        Matrix op = translation.times(scaling).times(rotation);
        Matrix M0 = op.times(new Matrix((double[][])new double[][]{{x0}, {y0}, {1.0}}));
        Matrix M1 = op.times(new Matrix((double[][])new double[][]{{x1}, {y1}, {1.0}}));
        Matrix M2 = op.times(new Matrix((double[][])new double[][]{{x2}, {y2}, {1.0}}));
        Matrix M3 = op.times(new Matrix((double[][])new double[][]{{x3}, {y3}, {1.0}}));
        this.curve = M0.get(0, 0) <= M3.get(0, 0) ? new CubicCurve2D.Double(M0.get(0, 0), M0.get(1, 0), M1.get(0, 0), M1.get(1, 0), M2.get(0, 0), M2.get(1, 0), M3.get(0, 0), M3.get(1, 0)) : new CubicCurve2D.Double(M3.get(0, 0), M3.get(1, 0), M2.get(0, 0), M2.get(1, 0), M1.get(0, 0), M1.get(1, 0), M0.get(0, 0), M0.get(1, 0));
    }

    private double computeDistance(double[] x, double[] y) {
        int nbPoints = x.length;
        double sum = 0.0;
        for (int i = 0; i < nbPoints; ++i) {
            double delta = Math.hypot(x[i] - this.getCenter().x, y[i] - this.getCenter().y) - this.getRadius();
            sum += delta * delta;
        }
        return Math.sqrt(sum) / (double)nbPoints;
    }

    private void defineCircle(Point2D left, Point2D middle, Point2D right) {
        Line2D prevBisector = LineUtil.bisector(new Line2D.Double(left, middle));
        Line2D bisector = LineUtil.bisector(new Line2D.Double(middle, right));
        this.center = LineUtil.intersection(prevBisector.getP1(), prevBisector.getP2(), bisector.getP1(), bisector.getP2());
        this.radius = Math.hypot(this.center.getX() - right.getX(), this.center.getY() - right.getY());
    }

    public Circle getCircle() {
        Circle ele = new Circle(this.center.getX(), this.center.getY(), this.radius);
        return ele;
    }

    private void fit(double[] x, double[] y) {
        int nbPoints = x.length;
        if (nbPoints < 3) {
            throw new IllegalArgumentException("Less than 3 defining points");
        }
        Matrix design = new Matrix(nbPoints, 4);
        for (int i = 0; i < nbPoints; ++i) {
            double tx = x[i];
            double ty = y[i];
            design.set(i, 0, tx * tx + ty * ty);
            design.set(i, 1, tx);
            design.set(i, 2, ty);
            design.set(i, 3, 1.0);
            if (tx > this.xMax) {
                this.xMax = tx;
            }
            if (tx < this.xMin) {
                this.xMin = tx;
            }
            if (ty > this.yMax) {
                this.yMax = ty;
            }
            if (!(ty < this.yMin)) continue;
            this.yMin = ty;
        }
        Matrix scatter = design.transpose().times(design);
        Matrix first = new Matrix(4, 1);
        for (int i = 0; i < 4; ++i) {
            first.set(i, 0, -scatter.get(0, i));
        }
        Matrix newScatter = new Matrix(4, 4);
        for (int i = 0; i < 4; ++i) {
            for (int j = 1; j < 4; ++j) {
                newScatter.set(i, j - 1, scatter.get(i, j));
            }
            newScatter.set(i, 3, 0.0);
        }
        newScatter.set(0, 3, -0.5);
        Matrix newScatterInv = newScatter.inverse();
        Matrix Solution = newScatterInv.times(first);
        double D = Solution.get(0, 0);
        double E = Solution.get(1, 0);
        double F = Solution.get(2, 0);
        this.center = new Point2D.Double(-D / 2.0, -E / 2.0);
        this.radius = Math.sqrt(this.center.x * this.center.x + this.center.y * this.center.y - F);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

