/*
 * Decompiled with CFR 0.152.
 */
package jhpro.dtree;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import jhpro.dtree.BinTree;

public class DecisionTree
implements Serializable {
    static BufferedReader keyboardInput = new BufferedReader(new InputStreamReader(System.in));
    public static BinTree rootNode = null;
    public String description = "";

    public void createRoot(int newNodeID, String newQuestAns) {
        rootNode = new BinTree(newNodeID, newQuestAns);
        System.out.println("Created root node " + newNodeID);
    }

    public void addYesNode(int existingNodeID, int newNodeID, String newQuestAns) {
        if (rootNode == null) {
            System.out.println("ERROR: No root node!");
            return;
        }
        if (this.searchTreeAndAddYesNode(rootNode, existingNodeID, newNodeID, newQuestAns)) {
            System.out.println("Added node " + newNodeID + " onto \"yes\" branch of node " + existingNodeID);
        } else {
            System.out.println("Node " + existingNodeID + " not found");
        }
    }

    private boolean searchTreeAndAddYesNode(BinTree currentNode, int existingNodeID, int newNodeID, String newQuestAns) {
        if (currentNode.nodeID == existingNodeID) {
            if (currentNode.yesBranch == null) {
                currentNode.yesBranch = new BinTree(newNodeID, newQuestAns);
            } else {
                System.out.println("WARNING: Overwriting previous node (id = " + currentNode.yesBranch.nodeID + ") linked to yes branch of node " + existingNodeID);
                currentNode.yesBranch = new BinTree(newNodeID, newQuestAns);
            }
            return true;
        }
        if (currentNode.yesBranch != null) {
            if (this.searchTreeAndAddYesNode(currentNode.yesBranch, existingNodeID, newNodeID, newQuestAns)) {
                return true;
            }
            if (currentNode.noBranch != null) {
                return this.searchTreeAndAddYesNode(currentNode.noBranch, existingNodeID, newNodeID, newQuestAns);
            }
            return false;
        }
        return false;
    }

    public void addNoNode(int existingNodeID, int newNodeID, String newQuestAns) {
        if (rootNode == null) {
            System.out.println("ERROR: No root node!");
            return;
        }
        if (this.searchTreeAndAddNoNode(rootNode, existingNodeID, newNodeID, newQuestAns)) {
            System.out.println("Added node " + newNodeID + " onto \"no\" branch of node " + existingNodeID);
        } else {
            System.out.println("Node " + existingNodeID + " not found");
        }
    }

    private boolean searchTreeAndAddNoNode(BinTree currentNode, int existingNodeID, int newNodeID, String newQuestAns) {
        if (currentNode.nodeID == existingNodeID) {
            if (currentNode.noBranch == null) {
                currentNode.noBranch = new BinTree(newNodeID, newQuestAns);
            } else {
                System.out.println("WARNING: Overwriting previous node (id = " + currentNode.noBranch.nodeID + ") linked to yes branch of node " + existingNodeID);
                currentNode.noBranch = new BinTree(newNodeID, newQuestAns);
            }
            return true;
        }
        if (currentNode.yesBranch != null) {
            if (this.searchTreeAndAddNoNode(currentNode.yesBranch, existingNodeID, newNodeID, newQuestAns)) {
                return true;
            }
            if (currentNode.noBranch != null) {
                return this.searchTreeAndAddNoNode(currentNode.noBranch, existingNodeID, newNodeID, newQuestAns);
            }
            return false;
        }
        return false;
    }

    public BinTree queryBinTree(BinTree currentNode) throws IOException {
        if (currentNode.yesBranch == null) {
            if (currentNode.noBranch == null) {
                return currentNode;
            }
            System.out.println("Error: Missing \"Yes\" branch at \"" + currentNode.questOrAns + "\" question");
            return currentNode;
        }
        if (currentNode.noBranch == null) {
            System.out.println("Error: Missing \"No\" branch at \"" + currentNode.questOrAns + "\" question");
            return currentNode;
        }
        return currentNode;
    }

    private void askQuestion(BinTree currentNode) throws IOException {
        System.out.println(currentNode.questOrAns + " (enter \"Yes\" or \"No\")");
        String answer = keyboardInput.readLine();
        if (answer.equals("Yes")) {
            this.queryBinTree(currentNode.yesBranch);
        } else if (answer.equals("No")) {
            this.queryBinTree(currentNode.noBranch);
        } else {
            System.out.println("ERROR: Must answer \"Yes\" or \"No\"");
            this.askQuestion(currentNode);
        }
    }

    public String outputBinTree() {
        return this.outputBinTree("1", rootNode);
    }

    private String outputBinTree(String tag, BinTree currentNode) {
        if (currentNode == null) {
            return this.description;
        }
        this.description = this.description + "[" + tag + "] nodeID = " + Integer.toString(currentNode.nodeID) + ", question/answer = " + currentNode.questOrAns + "\n";
        this.outputBinTree(tag + ".1", currentNode.yesBranch);
        this.outputBinTree(tag + ".2", currentNode.noBranch);
        return this.description;
    }
}

