/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.tuning;

import edu.uci.jforests.tuning.TuningConfig;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ConfigGenerator {
    private List<String> configs;
    private String rootFolder;
    private int folds;
    private int fromRandomSeed;
    private int toRandomSeed;

    public ConfigGenerator(String rootFolder, int folds, int fromSeed, int toSeed) {
        this.rootFolder = rootFolder;
        this.folds = folds;
        this.configs = new ArrayList<String>();
        this.fromRandomSeed = fromSeed;
        this.toRandomSeed = toSeed;
    }

    public ConfigGenerator(String rootFolder, int folds, String randomSeeds) {
        this.rootFolder = rootFolder;
        this.folds = folds;
        this.configs = new ArrayList<String>();
        String[] seedParts = randomSeeds.split(":");
        this.fromRandomSeed = Integer.parseInt(seedParts[0]);
        this.toRandomSeed = seedParts.length == 1 ? this.fromRandomSeed : Integer.parseInt(seedParts[1]);
    }

    private void addLineToConfigs(String line) {
        for (int i = 0; i < this.configs.size(); ++i) {
            this.configs.set(i, this.configs.get(i) + line + "\n");
        }
    }

    private void addSingleValueParam(String key, String value) {
        this.addLineToConfigs(key + "=" + value);
    }

    private void addMultiValueParam(String key, String[] values) {
        ArrayList<String> newConfigs = new ArrayList<String>();
        for (String value : values) {
            for (String config : this.configs) {
                newConfigs.add(config + key + "=" + value + "\n");
            }
        }
        this.configs = newConfigs;
    }

    public void generateExperimentsConfigs(InputStream inputStream) throws Exception {
        String line;
        this.configs.clear();
        this.configs.add("");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() == 0 || line.startsWith("#")) {
                this.addLineToConfigs(line);
                continue;
            }
            String[] parts = line.trim().split("=");
            String key = parts[0].toLowerCase();
            String value = parts[1];
            if (!value.contains(";")) {
                this.addSingleValueParam(key, value);
                continue;
            }
            String[] values = value.split(";");
            this.addMultiValueParam(key, values);
        }
    }

    public List<TuningConfig> getConfigs(String trainFile, String validFile, String testFile, String featureNamesFile) throws Exception {
        ArrayList<TuningConfig> tuningConfigs = new ArrayList<TuningConfig>();
        for (int f = 1; f <= this.folds; ++f) {
            tuningConfigs.addAll(this.getConfigsForFold(f, trainFile, validFile, testFile, featureNamesFile));
        }
        return tuningConfigs;
    }

    public List<TuningConfig> getConfigsForFold(int f, String trainFile, String validFile, String testFile, String featureNamesFile) throws Exception {
        ArrayList<TuningConfig> tuningConfigs = new ArrayList<TuningConfig>();
        for (int i = 0; i < this.configs.size(); ++i) {
            for (int r = this.fromRandomSeed; r <= this.toRandomSeed; ++r) {
                TuningConfig config = new TuningConfig();
                config.setId(i);
                config.setFold(f);
                config.setRandomSeed(r);
                config.setConfigKey(this.configs.get(i));
                String foldRoot = this.folds > 1 ? this.rootFolder + "Fold" + f + "/" : this.rootFolder;
                String configText = "id=" + i + "\ninput.train=" + foldRoot + trainFile;
                if (validFile != null) {
                    configText = configText + "\ninput.valid=" + foldRoot + validFile;
                }
                if (testFile != null) {
                    configText = configText + "\ninput.test=" + foldRoot + testFile;
                }
                if (featureNamesFile != null) {
                    configText = configText + "\ninput.train.feature-names-file=" + this.rootFolder + featureNamesFile;
                }
                configText = configText + "\nparams.random-seed=" + r;
                config.setConfigText(configText + "\n" + this.configs.get(i));
                tuningConfigs.add(config);
            }
        }
        return tuningConfigs;
    }
}

