/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.trees.decision;

import edu.uci.jforests.util.Constants;
import edu.uci.jforests.util.FloatingPointUtil;

public class Entropy {
    public static double getEntropy(double[] dist) {
        double numerator = 0.0;
        double total = 0.0;
        for (int i = 0; i < dist.length; ++i) {
            numerator -= Entropy.entropyLn(dist[i]);
            total += dist[i];
        }
        if (FloatingPointUtil.equal(total, 0.0)) {
            return 0.0;
        }
        return (numerator + Entropy.entropyLn(total)) / (total * Constants.LN2);
    }

    public static double getSplitEntropy(double[] leftDist, double[] rightDist) {
        double numerator = 0.0;
        double leftTotal = 0.0;
        for (int i = 0; i < leftDist.length; ++i) {
            numerator -= Entropy.entropyLn(leftDist[i]);
            leftTotal += leftDist[i];
        }
        numerator += Entropy.entropyLn(leftTotal);
        double rightTotal = 0.0;
        for (int i = 0; i < rightDist.length; ++i) {
            numerator -= Entropy.entropyLn(rightDist[i]);
            rightTotal += rightDist[i];
        }
        numerator += Entropy.entropyLn(rightTotal);
        double total = leftTotal + rightTotal;
        if (FloatingPointUtil.equal(total, 0.0)) {
            return 0.0;
        }
        return numerator / (total * Constants.LN2);
    }

    private static double entropyLn(double num) {
        if (num < 1.0E-6) {
            return 0.0;
        }
        return num * Math.log(num);
    }
}

