/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.trees;

import edu.uci.jforests.dataset.Dataset;
import edu.uci.jforests.learning.trees.TreeSplit;
import edu.uci.jforests.sample.Sample;
import edu.uci.jforests.util.ArraysUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class Tree
implements Cloneable {
    public int numLeaves;
    protected int[] leftChild;
    protected int[] rightChild;
    protected int[] splitFeatures;
    protected int[] thresholds;
    protected double[] originalThresholds;

    public void init(int maxLeaves) {
        this.leftChild = new int[maxLeaves - 1];
        this.rightChild = new int[maxLeaves - 1];
        this.splitFeatures = new int[maxLeaves - 1];
        this.thresholds = new int[maxLeaves - 1];
        this.originalThresholds = new double[maxLeaves - 1];
        this.numLeaves = 1;
    }

    protected void copyTo(Tree copy) {
        copy.init(this.leftChild.length + 1);
        copy.numLeaves = this.numLeaves;
        System.arraycopy(this.leftChild, 0, copy.leftChild, 0, this.numLeaves - 1);
        System.arraycopy(this.rightChild, 0, copy.rightChild, 0, this.numLeaves - 1);
        System.arraycopy(this.splitFeatures, 0, copy.splitFeatures, 0, this.numLeaves - 1);
        System.arraycopy(this.thresholds, 0, copy.thresholds, 0, this.numLeaves - 1);
        System.arraycopy(this.originalThresholds, 0, copy.originalThresholds, 0, this.numLeaves - 1);
    }

    public int getLeftChild(int node) {
        return this.leftChild[node];
    }

    public void setLeftChild(int node, int newChild) {
        this.leftChild[node] = newChild;
    }

    public int getRightChild(int node) {
        return this.rightChild[node];
    }

    public void setRightChild(int node, int newChild) {
        this.rightChild[node] = newChild;
    }

    public int getSplitFeature(int node) {
        return this.splitFeatures[node];
    }

    public int getThreshold(int node) {
        return this.thresholds[node];
    }

    public double getOriginalThreshold(int node) {
        return this.originalThresholds[node];
    }

    public int getLeaf(Dataset dataset, int instanceIndex) {
        if (this.numLeaves == 1) {
            return 0;
        }
        int node = 0;
        while (node >= 0) {
            if (dataset.getFeatureValue(instanceIndex, this.splitFeatures[node]) <= this.thresholds[node]) {
                node = this.leftChild[node];
                continue;
            }
            node = this.rightChild[node];
        }
        return ~node;
    }

    public int getLeafFromOriginalThreshold(Dataset dataset, int instanceIndex) {
        if (this.numLeaves == 1) {
            return 0;
        }
        int node = 0;
        while (node >= 0) {
            if (dataset.getOriginalFeatureValue(instanceIndex, this.splitFeatures[node]) <= this.originalThresholds[node]) {
                node = this.leftChild[node];
                continue;
            }
            node = this.rightChild[node];
        }
        return ~node;
    }

    public int getLeafFromOriginalThreshold(double[] featureVector) {
        if (this.numLeaves == 1) {
            return 0;
        }
        int node = 0;
        while (node >= 0) {
            if (featureVector[this.splitFeatures[node]] <= this.originalThresholds[node]) {
                node = this.leftChild[node];
                continue;
            }
            node = this.rightChild[node];
        }
        return ~node;
    }

    public int getParent(int node) {
        int parent = ArraysUtil.findIndex(this.leftChild, node, this.numLeaves - 1);
        if (parent >= 0) {
            return parent;
        }
        parent = ArraysUtil.findIndex(this.rightChild, node, this.numLeaves - 1);
        if (parent >= 0) {
            return parent;
        }
        return -1;
    }

    public int[] getNodeParents(int node) {
        ArrayList<Integer> parents = new ArrayList<Integer>();
        int parent = this.getParent(node);
        while (parent >= 0) {
            parents.add(parent);
            parent = this.getParent(parent);
        }
        int[] result = new int[parents.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)parents.get(parents.size() - i - 1);
        }
        return result;
    }

    public void loadLeavesInSubtree(int node, List<Integer> leaves) {
        if (node < 0) {
            leaves.add(~node);
        } else {
            this.loadLeavesInSubtree(this.leftChild[node], leaves);
            this.loadLeavesInSubtree(this.rightChild[node], leaves);
        }
    }

    public int split(int leaf, TreeSplit split) {
        int indexOfNewNonLeaf = this.numLeaves - 1;
        int parent = ArraysUtil.findIndex(this.leftChild, ~leaf, this.numLeaves - 1);
        if (parent >= 0) {
            this.leftChild[parent] = indexOfNewNonLeaf;
        } else {
            parent = ArraysUtil.findIndex(this.rightChild, ~leaf, this.numLeaves - 1);
            if (parent >= 0) {
                this.rightChild[parent] = indexOfNewNonLeaf;
            }
        }
        this.splitFeatures[indexOfNewNonLeaf] = split.feature;
        this.thresholds[indexOfNewNonLeaf] = split.threshold;
        this.originalThresholds[indexOfNewNonLeaf] = split.originalThreshold;
        this.leftChild[indexOfNewNonLeaf] = ~leaf;
        this.rightChild[indexOfNewNonLeaf] = ~this.numLeaves;
        ++this.numLeaves;
        return indexOfNewNonLeaf;
    }

    private int getNodeLabel(int n) {
        if (n < 0) {
            return -1 - ~n;
        }
        return n;
    }

    protected abstract void addCustomData(String var1, StringBuilder var2);

    public abstract void loadCustomData(String var1) throws Exception;

    public String toString(double weight, int indentationLevel) {
        String linePrefix = "";
        for (int i = 0; i < indentationLevel; ++i) {
            linePrefix = linePrefix + "\t";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n" + linePrefix + "<Tree leaves=\"" + this.numLeaves + "\" weight=\"" + weight + "\">");
        StringBuilder sbFeatures = new StringBuilder();
        StringBuilder sbLeftChildren = new StringBuilder();
        StringBuilder sbRightChild = new StringBuilder();
        StringBuilder sbThreshold = new StringBuilder();
        StringBuilder sbOriginalThreshold = new StringBuilder();
        int numNonLeaves = this.numLeaves - 1;
        for (int n = 0; n < numNonLeaves; ++n) {
            sbFeatures.append(" " + this.splitFeatures[n]);
            sbLeftChildren.append(" " + this.getNodeLabel(this.leftChild[n]));
            sbRightChild.append(" " + this.getNodeLabel(this.rightChild[n]));
            sbThreshold.append(" " + this.thresholds[n]);
            sbOriginalThreshold.append(" " + this.originalThresholds[n]);
        }
        sb.append("\n" + linePrefix + "\t<SplitFeatures>" + sbFeatures.toString().trim() + "</SplitFeatures>");
        sb.append("\n" + linePrefix + "\t<LeftChildren>" + sbLeftChildren.toString().trim() + "</LeftChildren>");
        sb.append("\n" + linePrefix + "\t<RightChildren>" + sbRightChild.toString().trim() + "</RightChildren>");
        sb.append("\n" + linePrefix + "\t<Thresholds>" + sbThreshold.toString().trim() + "</Thresholds>");
        sb.append("\n" + linePrefix + "\t<OriginalThresholds>" + sbOriginalThreshold.toString().trim() + "</OriginalThresholds>");
        this.addCustomData(linePrefix, sb);
        sb.append("\n" + linePrefix + "</Tree>");
        return sb.toString();
    }

    protected String removeXmlTag(String line, String tagName) {
        return line.trim().replace(tagName, "").replace("<>", "").replace("</>", "");
    }

    public void loadFromString(int numLeaves, String splitFeaturesLine, String leftChildrenLine, String rightChildrenLine, String thresholdsLine, String originalThresholdsLine) throws Exception {
        this.splitFeatures = ArraysUtil.loadIntArrayFromLine(this.removeXmlTag(splitFeaturesLine, "SplitFeatures"), numLeaves - 1);
        this.leftChild = ArraysUtil.loadIntArrayFromLine(this.removeXmlTag(leftChildrenLine, "LeftChildren"), numLeaves - 1);
        this.rightChild = ArraysUtil.loadIntArrayFromLine(this.removeXmlTag(rightChildrenLine, "RightChildren"), numLeaves - 1);
        this.thresholds = ArraysUtil.loadIntArrayFromLine(this.removeXmlTag(thresholdsLine, "Thresholds"), numLeaves - 1);
        this.originalThresholds = ArraysUtil.loadDoubleArrayFromLine(this.removeXmlTag(originalThresholdsLine, "OriginalThresholds"), numLeaves - 1);
        this.numLeaves = numLeaves;
    }

    public abstract void backfit(Sample var1);
}

