/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.trees;

import edu.uci.jforests.learning.trees.TreeLeafInstances;
import edu.uci.jforests.learning.trees.TreeSplit;
import edu.uci.jforests.sample.Sample;
import edu.uci.jforests.util.ArraysUtil;
import java.util.Random;

public abstract class CandidateSplitsForLeaf {
    protected int leafIdx;
    protected int numInstancesInLeaf;
    protected double totalWeightedCount;
    protected int[] indices;
    protected double[] targets;
    protected double[] weights;
    protected TreeSplit[] bestSplitPerFeature;
    protected int[] tempIndices;

    public abstract void init(int var1, TreeLeafInstances var2, Sample var3);

    public CandidateSplitsForLeaf(int numFeatures, int numInstances) {
        this.tempIndices = new int[numFeatures];
        for (int f = 0; f < numFeatures; ++f) {
            this.tempIndices[f] = f;
        }
        this.indices = new int[numInstances];
        this.targets = new double[numInstances];
        this.weights = new double[numInstances];
    }

    public TreeSplit getFeatureSplit(int f) {
        return this.bestSplitPerFeature[f];
    }

    public int getBestFeature() {
        int maxIndex = -1;
        double maxGain = Double.NEGATIVE_INFINITY;
        for (int f = 0; f < this.bestSplitPerFeature.length; ++f) {
            if (!(this.bestSplitPerFeature[f].gain > maxGain)) continue;
            maxGain = this.bestSplitPerFeature[f].gain;
            maxIndex = f;
        }
        return maxIndex;
    }

    public int getBestFeature(double splitFraction, Random rnd) {
        int maxIndex = -1;
        double maxGain = Double.NEGATIVE_INFINITY;
        ArraysUtil.shuffle(this.tempIndices, rnd);
        int maxFeaturesToConsider = Math.max((int)((double)this.bestSplitPerFeature.length * splitFraction), 1);
        int featuresConsidered = 0;
        for (int i = 0; i < this.bestSplitPerFeature.length && featuresConsidered < maxFeaturesToConsider; ++i) {
            int f = this.tempIndices[i];
            if (Double.isInfinite(this.bestSplitPerFeature[f].gain)) continue;
            ++featuresConsidered;
            if (!(this.bestSplitPerFeature[f].gain > maxGain)) continue;
            maxGain = this.bestSplitPerFeature[f].gain;
            maxIndex = f;
        }
        return maxIndex;
    }

    public int getLeafIndex() {
        return this.leafIdx;
    }

    public int getNumInstancesInLeaf() {
        return this.numInstancesInLeaf;
    }

    public double getTotalWeightedCount() {
        return this.totalWeightedCount;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public double[] getTargets() {
        return this.targets;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void init(int curLeafIndex) {
        this.leafIdx = curLeafIndex;
        for (int f = 0; f < this.bestSplitPerFeature.length; ++f) {
            this.bestSplitPerFeature[f].feature = f;
            this.bestSplitPerFeature[f].gain = Double.NEGATIVE_INFINITY;
        }
    }
}

