/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.bagging;

import edu.uci.jforests.config.ComponentConfig;
import edu.uci.jforests.util.ConfigHolder;
import java.util.Map;

public class BaggingConfig
extends ComponentConfig {
    public int bagCount = 10;
    private static final String BAG_COUNT = "bagging.bag-count";
    public double trainFraction = 0.67;
    private static final String TRAIN_FRACTION = "bagging.train-fraction";
    public boolean backfitting = false;
    private static final String BACKFITTING = "bagging.backfitting";

    @Override
    public void init(ConfigHolder config) {
        for (Map.Entry<Object, Object> entry : config.getEntries()) {
            String key = ((String)entry.getKey()).toLowerCase();
            String value = (String)entry.getValue();
            if (key.equals(BAG_COUNT)) {
                this.bagCount = Integer.parseInt(value);
                continue;
            }
            if (key.equals(TRAIN_FRACTION)) {
                this.trainFraction = Double.parseDouble(value);
                continue;
            }
            if (!key.equals(BACKFITTING)) continue;
            this.backfitting = Boolean.parseBoolean(value);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("bagging.bag-count: " + this.bagCount + "\n");
        sb.append("bagging.train-fraction: " + this.trainFraction + "\n");
        sb.append("bagging.backfitting: " + this.backfitting);
        return sb.toString();
    }
}

