/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.dataset;

import edu.uci.jforests.dataset.Feature;
import edu.uci.jforests.learning.trees.CandidateSplitsForLeaf;
import java.util.Arrays;

public abstract class Histogram {
    protected Feature feature;
    public int numValues;
    public boolean splittable;
    public int totalCount;
    public double totalWeightedCount;
    public int[] perValueCount;
    public double[] perValueWeightedCount;

    public Histogram(Feature feature) {
        this.feature = feature;
        this.numValues = feature.getNumberOfValues();
        this.splittable = true;
        this.totalCount = 0;
        this.totalWeightedCount = 0.0;
        this.perValueCount = new int[this.numValues];
        this.perValueWeightedCount = new double[this.numValues];
    }

    protected abstract void initCustomData(CandidateSplitsForLeaf var1, int[] var2);

    protected abstract void subtractCustomData(Histogram var1);

    public void init(CandidateSplitsForLeaf leafSplitCandidates, int[] instances) {
        this.totalCount = leafSplitCandidates.getNumInstancesInLeaf();
        this.totalWeightedCount = leafSplitCandidates.getTotalWeightedCount();
        Arrays.fill(this.perValueCount, 0);
        Arrays.fill(this.perValueWeightedCount, 0.0);
        this.initCustomData(leafSplitCandidates, instances);
    }

    public void subtractFromMe(Histogram child) throws Exception {
        if (child.numValues != this.numValues) {
            throw new Exception("inconsistent lengths for Histograms");
        }
        this.totalCount -= child.totalCount;
        this.totalWeightedCount -= child.totalWeightedCount;
        for (int i = 0; i < this.numValues; ++i) {
            int n = i;
            this.perValueCount[n] = this.perValueCount[n] - child.perValueCount[i];
            int n2 = i;
            this.perValueWeightedCount[n2] = this.perValueWeightedCount[n2] - child.perValueWeightedCount[i];
        }
        this.subtractCustomData(child);
    }
}

