/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.config;

import edu.uci.jforests.config.ComponentConfig;
import edu.uci.jforests.util.ConfigHolder;
import edu.uci.jforests.util.IOUtils;
import java.util.Map;

public class TrainingConfig
extends ComponentConfig {
    public String trainFilename = null;
    public static final String TRAIN_FILENAME = "input.train";
    public String validFilename = null;
    public static final String VALID_FILENAME = "input.valid";
    public String featureNamesFilename = null;
    private static final String FEATURENAMES_FILENAME = "input.train.feature-names-file";
    public String learningAlgorithm = null;
    private static final String LEARNING_ALGORITHM = "learning.algorithm";
    public String evaluationMetric = "AUC";
    private static final String LEARNING_EVALUATION_METRIC = "learning.evaluation-metric";
    public double trainFraction = 1.0;
    private static final String TRAIN_FRACTION = "input.train-fraction";
    public double validFraction = 1.0;
    private static final String VALID_FRACTION = "input.valid-fraction";
    public boolean validOutOfTrain = false;
    private static final String VALID_OUT_OF_TRAIN = "input.valid.out-of-train";
    public int numThreads = Runtime.getRuntime().availableProcessors();
    private static final String NUM_THREADS = "params.num-threads";
    public int randomSeed = 1;
    private static final String RANDOM_SEED = "params.random-seed";
    public boolean printIntermediateValidMeasurements = false;
    private static final String PRINT_INTERMEDIATE_VALID_MEASUREMENTS = "params.print-intermediate-valid-measurements";

    @Override
    public void init(ConfigHolder config) {
        for (Map.Entry<Object, Object> entry : config.getEntries()) {
            String key = ((String)entry.getKey()).toLowerCase();
            String value = (String)entry.getValue();
            if (key.equals(TRAIN_FILENAME)) {
                this.trainFilename = value;
                continue;
            }
            if (key.equals(VALID_FILENAME)) {
                this.validFilename = value;
                continue;
            }
            if (key.equals(FEATURENAMES_FILENAME)) {
                this.featureNamesFilename = value;
                continue;
            }
            if (key.equals(LEARNING_ALGORITHM)) {
                this.learningAlgorithm = value;
                continue;
            }
            if (key.equals(LEARNING_EVALUATION_METRIC)) {
                this.evaluationMetric = value;
                continue;
            }
            if (key.equals(TRAIN_FRACTION)) {
                this.trainFraction = Double.parseDouble(value);
                continue;
            }
            if (key.equals(VALID_FRACTION)) {
                this.validFraction = Double.parseDouble(value);
                continue;
            }
            if (key.equals(NUM_THREADS)) {
                this.numThreads = Integer.parseInt(value);
                continue;
            }
            if (key.equals(RANDOM_SEED)) {
                this.randomSeed = Integer.parseInt(value);
                continue;
            }
            if (key.equals(VALID_OUT_OF_TRAIN)) {
                this.validOutOfTrain = Boolean.parseBoolean(value);
                continue;
            }
            if (!key.equals(PRINT_INTERMEDIATE_VALID_MEASUREMENTS)) continue;
            this.printIntermediateValidMeasurements = Boolean.parseBoolean(value);
        }
    }

    public boolean validate(IOUtils ioUtils) {
        if (this.trainFilename == null) {
            this.errorMessage = "Training file is not set";
            return false;
        }
        if (!ioUtils.exists(this.trainFilename)) {
            this.errorMessage = "Training file: " + this.trainFilename + " does not exists.";
            return false;
        }
        if (this.validFilename != null && !ioUtils.exists(this.validFilename)) {
            this.errorMessage = "Validation file: " + this.validFilename + " does not exists.";
            return false;
        }
        if (this.learningAlgorithm == null) {
            this.errorMessage = "Learning algorithm is not specified.";
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("input.train: " + this.trainFilename + "\n");
        sb.append("input.valid: " + this.validFilename + "\n");
        sb.append("input.train.feature-names-file: " + this.featureNamesFilename + "\n");
        sb.append("learning.algorithm: " + this.learningAlgorithm + "\n");
        sb.append("input.train-fraction: " + this.trainFraction + "\n");
        sb.append("input.valid-fraction: " + this.validFraction + "\n");
        sb.append("params.num-threads: " + this.numThreads + "\n");
        sb.append("params.random-seed: " + this.randomSeed + "\n");
        sb.append("params.print-intermediate-valid-measurements: " + this.printIntermediateValidMeasurements + "\n");
        return sb.toString();
    }
}

