/*
 * Decompiled with CFR 0.152.
 */
package dt;

import dt.Instance;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

class Node {
    Node parent;
    Node[] children;
    int testFts;
    int numOfFts;
    List<Instance> instances;
    int predictedLabel = -1;

    Node(Node parent, List<Instance> instances) {
        this.parent = parent;
        this.children = new Node[Instance.FTSVALUERANGE];
        this.instances = instances;
        this.numOfFts = instances.get((int)0).fts.length;
        this.testFts = -1;
        int[] count = new int[]{0, 0};
        for (Instance t : this.instances) {
            int n = t.label;
            count[n] = count[n] + 1;
        }
        this.predictedLabel = count[0] > count[1] ? 0 : 1;
    }

    public int classify(Instance t) {
        if (this.testFts == -1) {
            return this.predictedLabel;
        }
        if (this.children[t.fts[this.testFts]] != null) {
            return this.children[t.fts[this.testFts]].classify(t);
        }
        return -1;
    }

    public void writeTreeXML(String filename) {
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(filename));
            writer.println("<?xml version=\"1.0\" ?>");
            writer.println("<tree>");
            writer.println("<declarations>");
            writer.println("<attributeDecl name=\"name\" type=\"String\" />");
            writer.println("<attributeDecl name=\"weight\" type=\"Real\" />");
            writer.println("</declarations>");
            this.writeTreeML(writer);
            writer.println("</tree>");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeTreeML(PrintWriter writer) {
        int i;
        if (this.testFts != -1) {
            writer.println("<branch>");
        } else {
            writer.println("<leaf>");
        }
        writer.print("<attribute name=\"name\" value=\"");
        if (this.parent == null) {
            writer.print("root");
        } else {
            for (i = 0; i < Instance.FTSVALUERANGE; ++i) {
                if (this != this.parent.children[i]) continue;
                writer.print("fts" + this.parent.testFts + " = " + i);
            }
        }
        writer.println("\" />");
        if (this.testFts != -1) {
            for (i = 0; i < Instance.FTSVALUERANGE; ++i) {
                if (this.children[i] == null) continue;
                this.children[i].writeTreeML(writer);
            }
            writer.println("</branch>");
        } else {
            writer.println("<attribute name=\"weight\" value=\"" + this.instances.size() + "\" />");
            writer.println("</leaf>");
        }
    }
}

