/*
 * Decompiled with CFR 0.152.
 */
package dt;

import dt.Algorithm;
import dt.Attribute;
import dt.Examples;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public class ID3Algorithm
implements Algorithm {
    private Examples examples;

    public ID3Algorithm(Examples examples) {
        this.examples = examples;
    }

    @Override
    public Attribute nextAttribute(Map<String, String> chosenAttributes, Set<String> usedAttributes) {
        double currentGain = 0.0;
        double bestGain = 0.0;
        String bestAttribute = "";
        if (this.examples.countPositive(chosenAttributes) == 0) {
            return new Attribute(false);
        }
        if (this.examples.countNegative(chosenAttributes) == 0) {
            return new Attribute(true);
        }
        for (String attribute : this.remainingAttributes(usedAttributes)) {
            currentGain = this.informationGain(attribute, chosenAttributes);
            if (!(currentGain > bestGain)) continue;
            bestAttribute = attribute;
            bestGain = currentGain;
        }
        if (bestGain == 0.0) {
            boolean classifier = this.examples.countPositive(chosenAttributes) > 0;
            return new Attribute(classifier);
        }
        return new Attribute(bestAttribute);
    }

    private Set<String> remainingAttributes(Set<String> usedAttributes) {
        Set<String> result = this.examples.extractAttributes();
        result.removeAll(usedAttributes);
        return result;
    }

    private double entropy(Map<String, String> specifiedAttributes) {
        double totalExamples = this.examples.count();
        double positiveExamples = this.examples.countPositive(specifiedAttributes);
        double negativeExamples = this.examples.countNegative(specifiedAttributes);
        return -this.nlog2(positiveExamples / totalExamples) - this.nlog2(negativeExamples / totalExamples);
    }

    private double entropy(String attribute, String decision, Map<String, String> specifiedAttributes) {
        double totalExamples = this.examples.count(attribute, decision, specifiedAttributes);
        double positiveExamples = this.examples.countPositive(attribute, decision, specifiedAttributes);
        double negativeExamples = this.examples.countNegative(attribute, decision, specifiedAttributes);
        return -this.nlog2(positiveExamples / totalExamples) - this.nlog2(negativeExamples / totalExamples);
    }

    private double informationGain(String attribute, Map<String, String> specifiedAttributes) {
        double sum = this.entropy(specifiedAttributes);
        double examplesCount = this.examples.count(specifiedAttributes);
        if (examplesCount == 0.0) {
            return sum;
        }
        Map<String, Set<String>> decisions = this.examples.extractDecisions();
        for (String decision : decisions.get(attribute)) {
            double entropyPart = this.entropy(attribute, decision, specifiedAttributes);
            double decisionCount = this.examples.countDecisions(attribute, decision);
            sum += -(decisionCount / examplesCount) * entropyPart;
        }
        return sum;
    }

    private double nlog2(double value) {
        if (value == 0.0) {
            return 0.0;
        }
        return value * FastMath.log((double)value) / FastMath.log((double)2.0);
    }
}

