/*
 * Decompiled with CFR 0.152.
 */
package com.seisw.util.geom;

import com.seisw.util.geom.Clip;
import com.seisw.util.geom.Poly;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class PolySimple
implements Poly {
    protected List<Point2D> m_List = new ArrayList<Point2D>();
    private boolean m_Contributes = true;

    public boolean equals(Object obj) {
        int that_num;
        if (!(obj instanceof PolySimple)) {
            return false;
        }
        PolySimple that = (PolySimple)obj;
        int this_num = this.m_List.size();
        if (this_num != (that_num = that.m_List.size())) {
            return false;
        }
        if (this_num > 0) {
            int that_index;
            double this_x = this.getX(0);
            double this_y = this.getY(0);
            int that_first_index = -1;
            for (that_index = 0; that_first_index == -1 && that_index < that_num; ++that_index) {
                double that_x = that.getX(that_index);
                double that_y = that.getY(that_index);
                if (this_x != that_x || this_y != that_y) continue;
                that_first_index = that_index;
            }
            if (that_first_index == -1) {
                return false;
            }
            that_index = that_first_index;
            for (int this_index = 0; this_index < this_num; ++this_index) {
                this_x = this.getX(this_index);
                this_y = this.getY(this_index);
                double that_x = that.getX(that_index);
                double that_y = that.getY(that_index);
                if (this_x != that_x || this_y != that_y) {
                    return false;
                }
                if (++that_index < that_num) continue;
                that_index = 0;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.m_List.hashCode();
        return result;
    }

    public String toString() {
        return "PolySimple: num_points=" + this.getNumPoints();
    }

    @Override
    public void clear() {
        this.m_List.clear();
    }

    @Override
    public void add(double x, double y) {
        this.add(new Point2D.Double(x, y));
    }

    @Override
    public void add(Point2D p) {
        this.m_List.add(p);
    }

    @Override
    public void add(Poly p) {
        throw new IllegalStateException("Cannot add poly to a simple poly.");
    }

    @Override
    public boolean isEmpty() {
        return this.m_List.isEmpty();
    }

    @Override
    public Rectangle2D getBounds() {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymax = -1.7976931348623157E308;
        for (int i = 0; i < this.m_List.size(); ++i) {
            double x = this.getX(i);
            double y = this.getY(i);
            if (x < xmin) {
                xmin = x;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (!(y > ymax)) continue;
            ymax = y;
        }
        return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    @Override
    public Poly getInnerPoly(int polyIndex) {
        if (polyIndex != 0) {
            throw new IllegalStateException("PolySimple only has one poly");
        }
        return this;
    }

    @Override
    public int getNumInnerPoly() {
        return 1;
    }

    @Override
    public int getNumPoints() {
        return this.m_List.size();
    }

    @Override
    public double getX(int index) {
        return this.m_List.get(index).getX();
    }

    @Override
    public double getY(int index) {
        return this.m_List.get(index).getY();
    }

    @Override
    public boolean isHole() {
        return false;
    }

    @Override
    public void setIsHole(boolean isHole) {
        throw new IllegalStateException("PolySimple cannot be a hole");
    }

    @Override
    public boolean isContributing(int polyIndex) {
        if (polyIndex != 0) {
            throw new IllegalStateException("PolySimple only has one poly");
        }
        return this.m_Contributes;
    }

    @Override
    public void setContributing(int polyIndex, boolean contributes) {
        if (polyIndex != 0) {
            throw new IllegalStateException("PolySimple only has one poly");
        }
        this.m_Contributes = contributes;
    }

    @Override
    public Poly intersection(Poly p) {
        return Clip.intersection(this, p, this.getClass());
    }

    @Override
    public Poly union(Poly p) {
        return Clip.union(this, p, this.getClass());
    }

    @Override
    public Poly xor(Poly p) {
        return Clip.xor(p, this, this.getClass());
    }

    @Override
    public double getArea() {
        if (this.getNumPoints() < 3) {
            return 0.0;
        }
        double ax = this.getX(0);
        double ay = this.getY(0);
        double area = 0.0;
        for (int i = 1; i < this.getNumPoints() - 1; ++i) {
            double bx = this.getX(i);
            double by = this.getY(i);
            double cx = this.getX(i + 1);
            double cy = this.getY(i + 1);
            double tarea = (cx - bx) * (ay - by) - (ax - bx) * (cy - by);
            area += tarea;
        }
        area = 0.5 * Math.abs(area);
        return area;
    }

    @Override
    public Poly subtract(Poly p) {
        return Clip.diff(this, p, this.getClass());
    }

    @Override
    public Polygon getPolygon() {
        Polygon jp = new Polygon();
        for (int i = 0; i < this.getNumPoints(); ++i) {
            jp.addPoint((int)this.getX(i), (int)this.getY(i));
        }
        return jp;
    }
}

