/*
 * Decompiled with CFR 0.152.
 */
package com.lagodiuk.gp.symbolic.example;

import com.lagodiuk.gp.symbolic.DerivativeFitness;
import com.lagodiuk.gp.symbolic.SymbolicRegressionEngine;
import com.lagodiuk.gp.symbolic.SymbolicRegressionIterationListener;
import com.lagodiuk.gp.symbolic.interpreter.Expression;
import com.lagodiuk.gp.symbolic.interpreter.Functions;
import java.util.LinkedList;
import java.util.List;

public class LauncherDerivative {
    public static void main(String[] args) {
        DerivativeFitness fitnessFunc = new DerivativeFitness(){

            @Override
            public double f(double x) {
                return x * x * x + 10.0 * x + Math.pow(3.0, x);
            }
        };
        fitnessFunc.setLeft(-10.0).setRight(10.0).setStep(0.5).setDx(0.01);
        SymbolicRegressionEngine engine = new SymbolicRegressionEngine(fitnessFunc, LauncherDerivative.list("x"), LauncherDerivative.list(Functions.values()));
        engine.addIterationListener(new SymbolicRegressionIterationListener(){
            private double prevFitValue = -1.0;

            @Override
            public void update(SymbolicRegressionEngine engine) {
                Expression bestSyntaxTree = engine.getBestSyntaxTree();
                double currFitValue = engine.fitness(bestSyntaxTree);
                if (Double.compare(currFitValue, this.prevFitValue) != 0) {
                    System.out.println("Func = " + bestSyntaxTree.print());
                }
                System.out.println(String.format("%s \t %s", engine.getIteration(), currFitValue));
                this.prevFitValue = currFitValue;
                if (currFitValue < 10.0) {
                    engine.terminate();
                }
            }
        });
        engine.evolve(200);
        System.out.println(engine.getBestSyntaxTree().print());
    }

    private static <T> List<T> list(T ... items) {
        LinkedList<T> list = new LinkedList<T>();
        for (T item : items) {
            list.add(item);
        }
        return list;
    }
}

