/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.survival.nonparametrics.independentsamples;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.AssociativeArray2D;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TransposeDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;

public class Logrank {
    public static double getPvalue(TransposeDataCollection transposeDataCollection) {
        if (transposeDataCollection.size() != 2) {
            throw new IllegalArgumentException("The collection must contain observations from 2 groups.");
        }
        Object[] keys = transposeDataCollection.keySet().toArray();
        HashMap<Object, Integer> n = new HashMap<Object, Integer>();
        n.put(keys[0], 0);
        n.put(keys[1], 0);
        PriorityQueue<Double> censoredData = new PriorityQueue<Double>();
        PriorityQueue<Double> uncensoredData = new PriorityQueue<Double>();
        for (Map.Entry<Object, FlatDataCollection> entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            FlatDataCollection flatDataCollection = entry.getValue();
            for (Object value : flatDataCollection) {
                String str = value.toString();
                if (str.endsWith("+")) {
                    censoredData.add(Double.valueOf(str.substring(0, str.length() - "+".length())));
                } else {
                    uncensoredData.add(TypeInference.toDouble(value));
                }
                n.put(j, (Integer)n.get(j) + 1);
            }
        }
        Double currentCensored = null;
        Double currentUncensored = null;
        AssociativeArray2D testTable = new AssociativeArray2D();
        do {
            Double ti;
            String key;
            Object value;
            if (currentCensored == null) {
                currentCensored = (Double)censoredData.poll();
            }
            if (currentUncensored == null) {
                currentUncensored = (Double)uncensoredData.poll();
            }
            if (currentUncensored == null) {
                key = currentCensored.toString().concat("+");
                ti = currentCensored;
                currentCensored = null;
            } else if (currentCensored == null) {
                key = currentUncensored.toString();
                ti = currentUncensored;
                currentUncensored = null;
            } else if (currentCensored < currentUncensored) {
                key = currentCensored.toString().concat("+");
                ti = currentCensored;
                currentCensored = null;
            } else {
                key = currentUncensored.toString();
                ti = currentUncensored;
                currentUncensored = null;
            }
            value = testTable.get2d(key, "mi");
            if (value != null) {
                testTable.put2d(key, "mi", (Integer)value + 1);
                continue;
            }
            testTable.put2d(key, "mi", 1);
            testTable.put2d(key, "rti", 0);
            for (Map.Entry entry : transposeDataCollection.entrySet()) {
                FlatDataCollection flatDataCollection = (FlatDataCollection)entry.getValue();
                for (Object value2 : flatDataCollection) {
                    String str = value2.toString();
                    double v = str.endsWith("+") ? Double.valueOf(str.substring(0, str.length() - "+".length())).doubleValue() : TypeInference.toDouble(value2).doubleValue();
                    if (!(v >= ti)) continue;
                    testTable.put2d(key, "rti", (Integer)testTable.get2d(key, "rti") + 1);
                }
            }
        } while (currentCensored != null || currentUncensored != null || !censoredData.isEmpty() || !uncensoredData.isEmpty());
        double VarS = 0.0;
        Iterator<Object> previousUncencoredKey = null;
        for (Map.Entry<Object, AssociativeArray> entry : testTable.entrySet()) {
            Iterator<Object> ti = entry.getKey();
            AssociativeArray testRow = entry.getValue();
            double previousUncencoredValue = 0.0;
            Object tmp = testTable.get2d(previousUncencoredKey, "eti");
            if (tmp != null) {
                previousUncencoredValue = TypeInference.toDouble(tmp);
            }
            if (!ti.toString().endsWith("+")) {
                double mi = testRow.getDouble("mi");
                double rti = testRow.getDouble("rti");
                double eti = previousUncencoredValue + mi / rti;
                testRow.put("eti", eti);
                testRow.put("wi", 1.0 - eti);
                previousUncencoredKey = ti;
            } else {
                testRow.put("wi", -previousUncencoredValue);
            }
            double wi = testRow.getDouble("wi");
            VarS += testRow.getDouble("mi") * wi * wi;
        }
        double S = 0.0;
        for (Object value : transposeDataCollection.get(keys[0])) {
            String key;
            Double v;
            String str = value.toString();
            if (str.endsWith("+")) {
                v = Double.valueOf(str.substring(0, str.length() - "+".length()));
                key = v.toString() + "+";
            } else {
                v = TypeInference.toDouble(value);
                key = v.toString();
            }
            double wi = TypeInference.toDouble(testTable.get2d(key, "wi"));
            S += wi;
        }
        double n0 = ((Integer)n.get(keys[0])).doubleValue();
        double n1 = ((Integer)n.get(keys[1])).doubleValue();
        double Z = S / Math.sqrt(VarS *= n0 * n1 / ((n0 + n1) * (n0 + n1 - 1.0)));
        double pvalue = Logrank.scoreToPvalue(Z);
        return pvalue;
    }

    public static boolean test(TransposeDataCollection transposeDataCollection, boolean is_twoTailed, double aLevel) {
        double pvalue = Logrank.getPvalue(transposeDataCollection);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score) {
        return ContinuousDistributions.gaussCdf(score);
    }
}

