/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.parametrics.relatedsamples;

import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class NormalRelatedSamples {
    public static boolean testMean(double dbar, int n, double dbarStd, boolean is_twoTailed, double aLevel) {
        if (n <= 0 || dbarStd <= 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double z = dbar / (dbarStd / Math.sqrt(n));
        boolean rejectH0 = NormalRelatedSamples.checkCriticalValue(z, is_twoTailed, aLevel);
        return rejectH0;
    }

    private static boolean checkCriticalValue(double score, boolean is_twoTailed, double aLevel) {
        double probability = ContinuousDistributions.gaussCdf(score);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (probability <= a || probability >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }
}

