/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.parametrics.independentsamples;

import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class StudentsIndependentSamples {
    public static boolean testMeansUnknownNotEqualVars(double xbar, double ybar, int n, int m, double stdx, double stdy, boolean is_twoTailed, double aLevel) {
        if (n <= 1 || stdx <= 0.0 || m <= 1 || stdy <= 0.0) {
            throw new IllegalArgumentException("The values of the provided parameters are not within the permitted range.");
        }
        double varx = stdx * stdx;
        double vary = stdy * stdy;
        double t = (xbar - ybar) / Math.sqrt(varx / (double)n + vary / (double)m);
        int df = (int)Math.round(Math.pow(varx / (double)n + vary / (double)m, 2.0) / (Math.pow(varx / (double)n, 2.0) / (double)(n - 1) + Math.pow(vary / (double)m, 2.0) / (double)(m - 1)));
        boolean rejectH0 = StudentsIndependentSamples.checkCriticalValue(t, df, is_twoTailed, aLevel);
        return rejectH0;
    }

    public static boolean testMeansUnknownEqualVars(double xbar, double ybar, int n, int m, double stdx, double stdy, boolean is_twoTailed, double aLevel) {
        if (n <= 1 || stdx <= 0.0 || m <= 1 || stdy <= 0.0) {
            throw new IllegalArgumentException("The values of the provided parameters are not within the permitted range.");
        }
        double PooledVariance = ((double)(n - 1) * stdx * stdx + (double)(m - 1) * stdy * stdy) / ((double)(n + m) - 2.0);
        double t = (xbar - ybar) / Math.sqrt(PooledVariance / (double)n + PooledVariance / (double)m);
        int df = n + m - 2;
        boolean rejectH0 = StudentsIndependentSamples.checkCriticalValue(t, df, is_twoTailed, aLevel);
        return rejectH0;
    }

    private static boolean checkCriticalValue(double score, int df, boolean is_twoTailed, double aLevel) {
        double probability = ContinuousDistributions.studentsCdf(score, df);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (probability <= a || probability >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }
}

