/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.parametrics.independentsamples;

import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class NormalIndependentSamples {
    public static boolean testMeans(double xbar, double ybar, int n, int m, double stdx, double stdy, boolean is_twoTailed, double aLevel) {
        if (n <= 0 || stdx <= 0.0 || m <= 0 || stdy <= 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double z = (xbar - ybar) / Math.sqrt(stdx * stdx / (double)n + stdy * stdy / (double)m);
        boolean rejectH0 = NormalIndependentSamples.checkCriticalValue(z, is_twoTailed, aLevel);
        return rejectH0;
    }

    public static boolean testPercentages(double p1bar, double p2bar, int n1, int n2, boolean is_twoTailed, double aLevel) {
        if (n1 <= 0 || p1bar < 0.0 || n2 <= 0 || p2bar < 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double z = (p1bar - p2bar) / Math.sqrt(p1bar * (1.0 - p1bar) / (double)n1 + p2bar * (1.0 - p2bar) / (double)n2);
        boolean rejectH0 = NormalIndependentSamples.checkCriticalValue(z, is_twoTailed, aLevel);
        return rejectH0;
    }

    public static boolean testOddsRatio(int n11, int n12, int n21, int n22, boolean is_twoTailed, double aLevel) {
        if (n11 <= 0 || n12 <= 0 || n21 <= 0 || n22 <= 0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double thita = (double)n11 * (double)n22 / (double)(n12 * n21);
        double z = Math.log(thita) / Math.sqrt(1.0 / (double)n11 + 1.0 / (double)n12 + 1.0 / (double)n21 + 1.0 / (double)n22);
        boolean rejectH0 = NormalIndependentSamples.checkCriticalValue(z, is_twoTailed, aLevel);
        return rejectH0;
    }

    private static boolean checkCriticalValue(double score, boolean is_twoTailed, double aLevel) {
        double probability = ContinuousDistributions.gaussCdf(score);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (probability <= a || probability >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }
}

