/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.descriptivestatistics;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.AssociativeArray2D;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;

public class CensoredDescriptives {
    public static final String CENSORED_NUMBER_POSTFIX = "+";

    public static AssociativeArray2D survivalFunction(FlatDataCollection flatDataCollection) {
        AssociativeArray2D survivalFunction = new AssociativeArray2D();
        PriorityQueue<Double> censoredData = new PriorityQueue<Double>();
        PriorityQueue<Double> uncensoredData = new PriorityQueue<Double>();
        int n = flatDataCollection.size();
        if (n == 0) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        for (Object value : flatDataCollection) {
            String str = value.toString();
            if (str.endsWith(CENSORED_NUMBER_POSTFIX)) {
                censoredData.add(Double.valueOf(str.substring(0, str.length() - CENSORED_NUMBER_POSTFIX.length())));
                continue;
            }
            uncensoredData.add(TypeInference.toDouble(value));
        }
        Double currentCensored = null;
        Double currentUncensored = null;
        int i = 1;
        double previousUncensoredValue = 1.0;
        double varianceDenominator = 0.0;
        do {
            String key;
            if (currentCensored == null) {
                currentCensored = (Double)censoredData.poll();
            }
            if (currentUncensored == null) {
                currentUncensored = (Double)uncensoredData.poll();
            }
            boolean isCensored = false;
            if (currentUncensored == null) {
                key = currentCensored.toString().concat(CENSORED_NUMBER_POSTFIX);
                currentCensored = null;
                isCensored = true;
            } else if (currentCensored == null) {
                key = currentUncensored.toString();
                currentUncensored = null;
            } else if (currentCensored < currentUncensored) {
                key = currentCensored.toString().concat(CENSORED_NUMBER_POSTFIX);
                currentCensored = null;
                isCensored = true;
            } else {
                key = currentUncensored.toString();
                currentUncensored = null;
            }
            Integer previousMi = (Integer)survivalFunction.get2d(key, "mi");
            if (previousMi == null) {
                previousMi = 0;
            }
            survivalFunction.put2d(key, "i", i);
            survivalFunction.put2d(key, "mi", previousMi + 1);
            if (!isCensored) {
                survivalFunction.put2d(key, "r", i);
                double Sti = (double)(n - i) / ((double)(n - i) + 1.0) * previousUncensoredValue;
                if (n - i > 0) {
                    varianceDenominator += 1.0 / ((double)(n - i) * ((double)(n - i) + 1.0));
                }
                survivalFunction.put2d(key, "Sti", Sti);
                survivalFunction.put2d(key, "varianceSti", Sti * Sti * varianceDenominator);
                previousUncensoredValue = Sti;
            }
            ++i;
        } while (currentCensored != null || currentUncensored != null || !censoredData.isEmpty() || !uncensoredData.isEmpty());
        return survivalFunction;
    }

    public static double median(AssociativeArray2D survivalFunction) {
        Double ApointTi = null;
        Double BpointTi = null;
        int n = survivalFunction.size();
        if (n == 0) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        for (Map.Entry<Object, AssociativeArray> entry : survivalFunction.entrySet()) {
            Object ti = entry.getKey();
            AssociativeArray row = entry.getValue();
            Double Sti = row.getDouble("Sti");
            if (Sti == null) continue;
            Double point2 = Double.valueOf(ti.toString());
            if (Math.abs(Sti - 0.5) < 1.0E-7) {
                return point2;
            }
            if (Sti > 0.5) {
                ApointTi = point2;
                continue;
            }
            BpointTi = point2;
            break;
        }
        if (n == 1) {
            return ApointTi != null ? ApointTi : BpointTi;
        }
        if (ApointTi == null || BpointTi == null) {
            throw new IllegalArgumentException("Invalid A and B points.");
        }
        double ApointTiValue = TypeInference.toDouble(survivalFunction.get2d(ApointTi.toString(), "Sti"));
        double BpointTiValue = TypeInference.toDouble(survivalFunction.get2d(BpointTi.toString(), "Sti"));
        double median = BpointTi - (BpointTiValue - 0.5) * (BpointTi - ApointTi) / (BpointTiValue - ApointTiValue);
        return median;
    }

    public static double mean(AssociativeArray2D survivalFunction) {
        if (survivalFunction.isEmpty()) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        return CensoredDescriptives.ar(survivalFunction, 0);
    }

    private static double ar(AssociativeArray2D survivalFunction, int r) {
        if (survivalFunction.isEmpty()) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        AssociativeArray2D survivalFunctionCopy = survivalFunction;
        Map.Entry<Object, AssociativeArray> lastRowEntry = null;
        Iterator<Map.Entry<Object, AssociativeArray>> iterator = survivalFunction.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, AssociativeArray> currentRowEntry;
            lastRowEntry = currentRowEntry = iterator.next();
        }
        if (lastRowEntry == null) {
            throw new IllegalArgumentException("The last observation can't be censored.");
        }
        AssociativeArray lastRow = (AssociativeArray)lastRowEntry.getValue();
        if (lastRow.get("Sti") == null) {
            survivalFunctionCopy = survivalFunction.copy();
            Object lastRowKey = lastRowEntry.getKey();
            AssociativeArray lastRowValue = survivalFunctionCopy.remove(lastRowKey);
            String str = lastRowKey.toString();
            Double newLastRowKey = Double.valueOf(str.substring(0, str.length() - CENSORED_NUMBER_POSTFIX.length()));
            newLastRowKey = Math.floor(newLastRowKey) + 1.0;
            survivalFunctionCopy.put2d(newLastRowKey, "i", lastRowValue.get("i"));
            survivalFunctionCopy.put2d(newLastRowKey, "r", lastRowValue.get("i"));
            survivalFunctionCopy.put2d(newLastRowKey, "Sti", 0.0);
            survivalFunctionCopy.put2d(newLastRowKey, "varianceSti", 0.0);
        }
        double Ar = 0.0;
        double StiPrevious = 1.0;
        double tiPrevious = 0.0;
        for (Map.Entry<Object, AssociativeArray> entry : survivalFunctionCopy.entrySet()) {
            Object ti = entry.getKey();
            AssociativeArray row = entry.getValue();
            Double Sti = row.getDouble("Sti");
            if (Sti == null) continue;
            double tiCurrent = Double.valueOf(ti.toString());
            if (row.getDouble("r") > (double)r) {
                Ar += StiPrevious * (tiCurrent - tiPrevious);
            }
            StiPrevious = Sti;
            tiPrevious = tiCurrent;
        }
        return Ar;
    }

    public static double meanVariance(AssociativeArray2D survivalFunction) {
        Number mi;
        AssociativeArray row;
        double meanVariance = 0.0;
        int m = 0;
        int n = 0;
        for (Map.Entry<Object, AssociativeArray> entry : survivalFunction.entrySet()) {
            row = entry.getValue();
            mi = (Number)row.get("mi");
            n += mi.intValue();
            if (row.get("Sti") != null) continue;
            m += mi.intValue();
        }
        for (Map.Entry<Object, AssociativeArray> entry : survivalFunction.entrySet()) {
            row = entry.getValue();
            if (row.get("Sti") == null) continue;
            mi = (Number)row.get("mi");
            Number r = (Number)row.get("r");
            double Ar = CensoredDescriptives.ar(survivalFunction, r.intValue());
            if (n - r.intValue() <= 0) continue;
            meanVariance += (double)mi.intValue() * (Ar * Ar) / ((double)(n - r.intValue()) * ((double)(n - r.intValue()) + 1.0));
        }
        return meanVariance *= (double)m / ((double)m - 1.0);
    }

    public static double meanStd(AssociativeArray2D survivalFunction) {
        return Math.sqrt(CensoredDescriptives.meanVariance(survivalFunction));
    }
}

