/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.mathematics.regularization;

import java.util.Map;

public class L2Regularizer {
    public static <K> void updateWeights(double l2, double learningRate, Map<K, Double> weights, Map<K, Double> newWeights) {
        if (l2 > 0.0) {
            for (Map.Entry<K, Double> e : weights.entrySet()) {
                K column = e.getKey();
                newWeights.put(column, newWeights.get(column) + l2 * e.getValue() * -learningRate);
            }
        }
    }

    public static <K> double estimatePenalty(double l2, Map<K, Double> weights) {
        double penalty = 0.0;
        if (l2 > 0.0) {
            double sumWeightsSquared = 0.0;
            for (double w : weights.values()) {
                sumWeightsSquared += w * w;
            }
            penalty = l2 * sumWeightsSquared / 2.0;
        }
        return penalty;
    }
}

