/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.preprocessing;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.concurrency.StreamMethods;
import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.abstracts.transformers.AbstractScaler;
import java.util.Map;
import java.util.Set;

public class BinaryScaler
extends AbstractScaler<ModelParameters, TrainingParameters> {
    protected BinaryScaler(TrainingParameters trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected BinaryScaler(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    @Override
    protected void _fit(Dataframe trainingData) {
    }

    @Override
    protected void _transform(Dataframe newData) {
        TrainingParameters trainingParameters = (TrainingParameters)this.knowledgeBase.getTrainingParameters();
        boolean scaleResponse = trainingParameters.getScaleResponse() && newData.getYDataType() == TypeInference.DataType.NUMERICAL;
        double threshold = trainingParameters.getThreshold();
        Set<TypeInference.DataType> supportedXDataTypes = this.getSupportedXDataTypes();
        Map<Object, TypeInference.DataType> xDataTypes = newData.getXDataTypes();
        this.streamExecutor.forEach(StreamMethods.stream(newData.entries(), this.isParallelized()), e -> {
            Record r = (Record)e.getValue();
            AssociativeArray xData = r.getX().copy();
            Object yData = r.getY();
            boolean modified = false;
            for (Object column : r.getX().keySet()) {
                if (!supportedXDataTypes.contains(xDataTypes.get(column))) continue;
                Object value = xData.remove(column);
                if (value != null) {
                    xData.put(column, this.scale(TypeInference.toDouble(value), threshold));
                }
                modified = true;
            }
            if (scaleResponse && yData != null) {
                Double value = TypeInference.toDouble(yData);
                yData = this.scale(value, threshold);
                modified = true;
            }
            if (modified) {
                Integer rId = (Integer)e.getKey();
                Record newR = new Record(xData, yData, r.getYPredicted(), r.getYPredictedProbabilities());
                newData._unsafe_set(rId, newR);
            }
        });
        newData.recalculateMeta();
    }

    private Boolean scale(Double value, double threshold) {
        return value > threshold;
    }

    public static class TrainingParameters
    extends AbstractScaler.AbstractTrainingParameters {
        private static final long serialVersionUID = 1L;
        private double threshold = 0.0;

        public double getThreshold() {
            return this.threshold;
        }

        public void setThreshold(double threshold) {
            this.threshold = threshold;
        }
    }

    public static class ModelParameters
    extends AbstractScaler.AbstractModelParameters {
        private static final long serialVersionUID = 1L;

        protected ModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }
    }
}

