/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.common.dataobjects;

import com.datumbox.framework.core.common.interfaces.Savable;
import com.datumbox.framework.core.machinelearning.common.interfaces.Parallelizable;
import com.datumbox.framework.core.machinelearning.common.interfaces.Trainable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TrainableBundle
implements Savable {
    private final String storageNameSeparator;
    private final Map<String, Trainable> bundle = new HashMap<String, Trainable>();

    public TrainableBundle(String storageNameSeparator) {
        this.storageNameSeparator = storageNameSeparator;
    }

    public Set<String> keySet() {
        return this.bundle.keySet();
    }

    public boolean containsKey(String key) {
        return this.bundle.containsKey(key);
    }

    public Trainable get(String key) {
        return this.bundle.get(key);
    }

    public Trainable put(String key, Trainable value) {
        return this.bundle.put(key, value);
    }

    public void setParallelized(boolean parallelized) {
        for (Trainable t : this.bundle.values()) {
            if (t == null || !(t instanceof Parallelizable)) continue;
            ((Parallelizable)((Object)t)).setParallelized(parallelized);
        }
    }

    @Override
    public void save(String storageName) {
        for (Map.Entry<String, Trainable> e : this.bundle.entrySet()) {
            Trainable t = e.getValue();
            if (t == null) continue;
            t.save(storageName + this.storageNameSeparator + e.getKey());
        }
    }

    @Override
    public void delete() {
        for (Trainable t : this.bundle.values()) {
            if (t == null) continue;
            t.delete();
        }
        this.bundle.clear();
    }

    @Override
    public void close() {
        for (Trainable t : this.bundle.values()) {
            if (t == null) continue;
            try {
                t.close();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.bundle.clear();
    }
}

