/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.common.text.analyzers;

public class PHPSimilarText {
    public static int similarityChars(String txt1, String txt2) {
        int sim = PHPSimilarText.similar_char(txt1, txt1.length(), txt2, txt2.length());
        return sim;
    }

    public static double similarityPercentage(String txt1, String txt2) {
        double sim = PHPSimilarText.similarityChars(txt1, txt2);
        return sim * 200.0 / (double)(txt1.length() + txt2.length());
    }

    private static void similar_str(String txt1, int len1, String txt2, int len2, Tuple t) {
        t.setMax(0);
        for (int p = 0; p < len1; ++p) {
            for (int q = 0; q < len2; ++q) {
                int l = 0;
                while (p + l < len1 && q + l < len2 && txt1.charAt(p + l) == txt2.charAt(q + l)) {
                    ++l;
                }
                if (l <= t.getMax()) continue;
                t.setMax(l);
                t.setPos1(p);
                t.setPos2(q);
            }
        }
    }

    private static int similar_char(String txt1, int len1, String txt2, int len2) {
        Tuple t = new Tuple();
        PHPSimilarText.similar_str(txt1, len1, txt2, len2, t);
        int sum = t.getMax();
        if (sum != 0) {
            if (t.getPos1() != 0 && t.getPos2() != 0) {
                sum += PHPSimilarText.similar_char(txt1, t.getPos1(), txt2, t.getPos2());
            }
            if (t.getPos1() + t.getMax() < len1 && t.getPos2() + t.getMax() < len2) {
                sum += PHPSimilarText.similar_char(txt1.substring(t.getPos1() + t.getMax()), len1 - t.getPos1() - t.getMax(), txt2.substring(t.getPos2() + t.getMax()), len2 - t.getPos2() - t.getMax());
            }
        }
        return sum;
    }

    private static class Tuple {
        private int pos1 = 0;
        private int pos2 = 0;
        private int max = 0;

        private Tuple() {
        }

        protected int getPos1() {
            return this.pos1;
        }

        protected void setPos1(int pos1) {
            this.pos1 = pos1;
        }

        protected int getPos2() {
            return this.pos2;
        }

        protected void setPos2(int pos2) {
            this.pos2 = pos2;
        }

        protected int getMax() {
            return this.max;
        }

        protected void setMax(int max) {
            this.max = max;
        }
    }
}

