/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.storage.abstracts;

import com.datumbox.framework.common.storage.abstracts.AbstractFileStorageConfiguration;
import com.datumbox.framework.common.storage.abstracts.AbstractStorageEngine;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public abstract class AbstractFileStorageEngine<SC extends AbstractFileStorageConfiguration>
extends AbstractStorageEngine<SC> {
    protected AbstractFileStorageEngine(String storageName, SC storageConfiguration) {
        super(storageName, storageConfiguration);
    }

    protected String getDirectory() {
        String directory = ((AbstractFileStorageConfiguration)this.storageConfiguration).getDirectory();
        if (directory == null || directory.isEmpty()) {
            directory = System.getProperty("java.io.tmpdir");
        }
        return directory;
    }

    protected Path getRootPath(String storageName) {
        return Paths.get(this.getDirectory() + File.separator + storageName, new String[0]);
    }

    protected boolean deleteIfExistsRecursively(Path path) throws IOException {
        try {
            return Files.deleteIfExists(path);
        }
        catch (DirectoryNotEmptyException ex) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            return true;
        }
    }

    protected boolean deleteDirectory(Path path, boolean cleanParent) throws IOException {
        boolean pathExists = this.deleteIfExistsRecursively(path);
        if (pathExists && cleanParent) {
            this.cleanEmptyParentDirectory(path.getParent());
            return true;
        }
        return false;
    }

    private void cleanEmptyParentDirectory(Path path) throws IOException {
        Path normPath = path.normalize();
        if (normPath.equals(Paths.get(this.getDirectory(), new String[0]).normalize()) || normPath.equals(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).normalize())) {
            return;
        }
        try {
            Files.deleteIfExists(path);
            this.cleanEmptyParentDirectory(path.getParent());
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
            // empty catch block
        }
    }

    protected boolean moveDirectory(Path src, Path target) throws IOException {
        if (Files.exists(src, new LinkOption[0])) {
            this.createDirectoryIfNotExists(target.getParent());
            this.deleteDirectory(target, false);
            Files.move(src, target, new CopyOption[0]);
            this.cleanEmptyParentDirectory(src.getParent());
            return true;
        }
        return false;
    }

    protected boolean createDirectoryIfNotExists(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
            return true;
        }
        return false;
    }
}

