/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.concurrency;

import com.datumbox.framework.common.concurrency.ConcurrencyConfiguration;
import com.datumbox.framework.common.concurrency.ThrottledExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class ThreadMethods {
    public static <T> void throttledExecution(Stream<T> stream, Consumer<T> consumer, ConcurrencyConfiguration concurrencyConfiguration) {
        if (concurrencyConfiguration.isParallelized()) {
            int maxThreads = concurrencyConfiguration.getMaxNumberOfThreadsPerTask();
            int maxTasks = 2 * maxThreads;
            ExecutorService executorService = Executors.newFixedThreadPool(maxThreads);
            ThrottledExecutor executor = new ThrottledExecutor(executorService, maxTasks);
            ((Stream)stream.sequential()).forEach(i -> executor.execute(() -> consumer.accept(i)));
            executorService.shutdown();
            try {
                executorService.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            Runnable runnable = () -> stream.forEach(consumer);
            runnable.run();
        }
    }

    public static <T> T forkJoinExecution(Callable<T> callable, ConcurrencyConfiguration concurrencyConfiguration, boolean parallelStream) {
        if (parallelStream && concurrencyConfiguration.isParallelized()) {
            try {
                ForkJoinPool pool = new ForkJoinPool(concurrencyConfiguration.getMaxNumberOfThreadsPerTask());
                Object results = ((ForkJoinTask)pool.submit((Callable)callable)).get();
                pool.shutdown();
                return (T)results;
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            return callable.call();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void forkJoinExecution(Runnable runnable, ConcurrencyConfiguration concurrencyConfiguration, boolean parallelStream) {
        if (parallelStream && concurrencyConfiguration.isParallelized()) {
            try {
                ForkJoinPool pool = new ForkJoinPool(concurrencyConfiguration.getMaxNumberOfThreadsPerTask());
                ((ForkJoinTask)pool.submit(runnable)).get();
                pool.shutdown();
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            runnable.run();
        }
    }
}

