/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.applications.datamodeling;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.machinelearning.MLBuilder;
import com.datumbox.framework.core.machinelearning.common.abstracts.AbstractTrainer;
import com.datumbox.framework.core.machinelearning.common.abstracts.featureselectors.AbstractFeatureSelector;
import com.datumbox.framework.core.machinelearning.common.abstracts.modelers.AbstractModeler;
import com.datumbox.framework.core.machinelearning.common.abstracts.transformers.AbstractEncoder;
import com.datumbox.framework.core.machinelearning.common.abstracts.transformers.AbstractScaler;
import com.datumbox.framework.core.machinelearning.common.dataobjects.TrainableBundle;
import com.datumbox.framework.core.machinelearning.common.interfaces.Parallelizable;
import com.datumbox.framework.core.machinelearning.common.interfaces.Trainable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Modeler
extends AbstractModeler<ModelParameters, TrainingParameters>
implements Parallelizable {
    protected static final String NS_KEY = "ns";
    protected static final String CE_KEY = "ce";
    protected static final String FS_KEY = "fs";
    protected static final String ML_KEY = "ml";
    protected List<String> pipeline = Arrays.asList("ns", "ce", "fs", "ml");
    private final TrainableBundle bundle;
    private boolean parallelized = true;

    protected Modeler(TrainingParameters trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
        this.bundle = new TrainableBundle(configuration.getStorageConfiguration().getStorageNameSeparator());
    }

    protected Modeler(String storageName, Configuration configuration) {
        super(storageName, configuration);
        this.bundle = new TrainableBundle(configuration.getStorageConfiguration().getStorageNameSeparator());
    }

    @Override
    public boolean isParallelized() {
        return this.parallelized;
    }

    @Override
    public void setParallelized(boolean parallelized) {
        this.parallelized = parallelized;
    }

    @Override
    public void _predict(Dataframe newData) {
        this.initBundle();
        this.bundle.setParallelized(this.isParallelized());
        Iterator<String> iterator = this.pipeline.iterator();
        block12: while (iterator.hasNext()) {
            String step;
            switch (step = iterator.next()) {
                case "ns": {
                    AbstractScaler numericalScaler = (AbstractScaler)this.bundle.get(NS_KEY);
                    if (numericalScaler == null) continue block12;
                    numericalScaler.transform(newData);
                    break;
                }
                case "ce": {
                    AbstractEncoder categoricalEncoder = (AbstractEncoder)this.bundle.get(CE_KEY);
                    if (categoricalEncoder == null) continue block12;
                    categoricalEncoder.transform(newData);
                    break;
                }
                case "fs": {
                    int numOfFS = ((TrainingParameters)this.getTrainingParameters()).getFeatureSelectorTrainingParametersList().size();
                    for (int i = 0; i < numOfFS; ++i) {
                        AbstractFeatureSelector featureSelector = (AbstractFeatureSelector)this.bundle.get(FS_KEY + i);
                        featureSelector.transform(newData);
                    }
                    continue block12;
                }
                case "ml": {
                    AbstractModeler modeler = (AbstractModeler)this.bundle.get(ML_KEY);
                    modeler.predict(newData);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid Pipeline Step");
                }
            }
        }
    }

    @Override
    protected void _fit(Dataframe trainingData) {
        TrainingParameters trainingParameters = (TrainingParameters)this.knowledgeBase.getTrainingParameters();
        Configuration configuration = this.knowledgeBase.getConfiguration();
        this.resetBundle();
        AbstractScaler.AbstractTrainingParameters nsParams = trainingParameters.getNumericalScalerTrainingParameters();
        AbstractScaler numericalScaler = null;
        if (nsParams != null) {
            numericalScaler = (AbstractScaler)MLBuilder.create(nsParams, configuration);
        }
        this.bundle.put(NS_KEY, numericalScaler);
        AbstractTrainer.AbstractTrainingParameters ceParams = trainingParameters.getCategoricalEncoderTrainingParameters();
        AbstractEncoder categoricalEncoder = null;
        if (ceParams != null) {
            categoricalEncoder = (AbstractEncoder)MLBuilder.create(ceParams, configuration);
        }
        this.bundle.put(CE_KEY, categoricalEncoder);
        List<AbstractTrainer.AbstractTrainingParameters> fsParamsList = trainingParameters.getFeatureSelectorTrainingParametersList();
        int numOfFS = fsParamsList.size();
        for (int i = 0; i < numOfFS; ++i) {
            AbstractTrainer.AbstractTrainingParameters fsParams = fsParamsList.get(i);
            AbstractFeatureSelector featureSelector = (AbstractFeatureSelector)MLBuilder.create(fsParams, configuration);
            this.bundle.put(FS_KEY + i, featureSelector);
        }
        AbstractTrainer.AbstractTrainingParameters mlParams = trainingParameters.getModelerTrainingParameters();
        AbstractModeler modeler = (AbstractModeler)MLBuilder.create(mlParams, configuration);
        this.bundle.put(ML_KEY, modeler);
        this.bundle.setParallelized(this.isParallelized());
        Iterator<String> iterator = this.pipeline.iterator();
        block13: while (iterator.hasNext()) {
            String step;
            switch (step = iterator.next()) {
                case "ns": {
                    if (numericalScaler == null) continue block13;
                    numericalScaler.fit_transform(trainingData);
                    break;
                }
                case "ce": {
                    if (categoricalEncoder == null) continue block13;
                    categoricalEncoder.fit_transform(trainingData);
                    break;
                }
                case "fs": {
                    for (int i = 0; i < numOfFS; ++i) {
                        AbstractFeatureSelector featureSelector = (AbstractFeatureSelector)this.bundle.get(FS_KEY + i);
                        featureSelector.fit_transform(trainingData);
                    }
                    continue block13;
                }
                case "ml": {
                    modeler.fit(trainingData);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid Pipeline Step");
                }
            }
        }
    }

    @Override
    public void save(String storageName) {
        this.initBundle();
        super.save(storageName);
        String knowledgeBaseName = this.createKnowledgeBaseName(storageName, this.knowledgeBase.getConfiguration().getStorageConfiguration().getStorageNameSeparator());
        this.bundle.save(knowledgeBaseName);
    }

    @Override
    public void delete() {
        this.initBundle();
        this.bundle.delete();
        super.delete();
    }

    @Override
    public void close() {
        this.initBundle();
        this.bundle.close();
        super.close();
    }

    private void resetBundle() {
        this.bundle.delete();
    }

    private void initBundle() {
        TrainingParameters trainingParameters = (TrainingParameters)this.knowledgeBase.getTrainingParameters();
        Configuration configuration = this.knowledgeBase.getConfiguration();
        String storageName = this.knowledgeBase.getStorageEngine().getStorageName();
        String separator = configuration.getStorageConfiguration().getStorageNameSeparator();
        if (!this.bundle.containsKey(NS_KEY)) {
            AbstractScaler.AbstractTrainingParameters nsParams = trainingParameters.getNumericalScalerTrainingParameters();
            AbstractScaler numericalScaler = null;
            if (nsParams != null) {
                numericalScaler = (AbstractScaler)MLBuilder.load(nsParams.getTClass(), storageName + separator + NS_KEY, configuration);
            }
            this.bundle.put(NS_KEY, numericalScaler);
        }
        if (!this.bundle.containsKey(CE_KEY)) {
            AbstractTrainer.AbstractTrainingParameters ceParams = trainingParameters.getCategoricalEncoderTrainingParameters();
            AbstractEncoder categoricalEncoder = null;
            if (ceParams != null) {
                categoricalEncoder = (AbstractEncoder)MLBuilder.load(ceParams.getTClass(), storageName + separator + CE_KEY, configuration);
            }
            this.bundle.put(CE_KEY, categoricalEncoder);
        }
        List<AbstractTrainer.AbstractTrainingParameters> fsParamsList = trainingParameters.getFeatureSelectorTrainingParametersList();
        int numOfFS = fsParamsList.size();
        for (int i = 0; i < numOfFS; ++i) {
            if (this.bundle.containsKey(FS_KEY + i)) continue;
            AbstractTrainer.AbstractTrainingParameters fsParams = fsParamsList.get(i);
            AbstractFeatureSelector featureSelector = (AbstractFeatureSelector)MLBuilder.load(fsParams.getTClass(), storageName + separator + FS_KEY + i, configuration);
            this.bundle.put(FS_KEY + i, featureSelector);
        }
        if (!this.bundle.containsKey(ML_KEY)) {
            AbstractTrainer.AbstractTrainingParameters mlParams = trainingParameters.getModelerTrainingParameters();
            this.bundle.put(ML_KEY, (Trainable)MLBuilder.load(mlParams.getTClass(), storageName + separator + ML_KEY, configuration));
        }
    }

    public static class TrainingParameters
    extends AbstractTrainer.AbstractTrainingParameters {
        private static final long serialVersionUID = 1L;
        private AbstractScaler.AbstractTrainingParameters numericalScalerTrainingParameters;
        private AbstractTrainer.AbstractTrainingParameters categoricalEncoderTrainingParameters;
        private List<AbstractTrainer.AbstractTrainingParameters> featureSelectorTrainingParametersList = new ArrayList<AbstractTrainer.AbstractTrainingParameters>();
        private AbstractTrainer.AbstractTrainingParameters modelerTrainingParameters;

        public AbstractScaler.AbstractTrainingParameters getNumericalScalerTrainingParameters() {
            return this.numericalScalerTrainingParameters;
        }

        public void setNumericalScalerTrainingParameters(AbstractScaler.AbstractTrainingParameters numericalScalerTrainingParameters) {
            this.numericalScalerTrainingParameters = numericalScalerTrainingParameters;
        }

        public AbstractTrainer.AbstractTrainingParameters getCategoricalEncoderTrainingParameters() {
            return this.categoricalEncoderTrainingParameters;
        }

        public void setCategoricalEncoderTrainingParameters(AbstractTrainer.AbstractTrainingParameters categoricalEncoderTrainingParameters) {
            this.categoricalEncoderTrainingParameters = categoricalEncoderTrainingParameters;
        }

        public List<AbstractTrainer.AbstractTrainingParameters> getFeatureSelectorTrainingParametersList() {
            return this.featureSelectorTrainingParametersList;
        }

        public void setFeatureSelectorTrainingParametersList(List<AbstractTrainer.AbstractTrainingParameters> featureSelectorTrainingParametersList) {
            this.featureSelectorTrainingParametersList = featureSelectorTrainingParametersList;
        }

        public AbstractTrainer.AbstractTrainingParameters getModelerTrainingParameters() {
            return this.modelerTrainingParameters;
        }

        public void setModelerTrainingParameters(AbstractTrainer.AbstractTrainingParameters modelerTrainingParameters) {
            this.modelerTrainingParameters = modelerTrainingParameters;
        }
    }

    public static class ModelParameters
    extends AbstractTrainer.AbstractModelParameters {
        private static final long serialVersionUID = 1L;

        protected ModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }
    }
}

