/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.transform;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.transform.RotatablePaperTransform;

public class PaperTransform
implements Cloneable {
    private final double xoff;
    private final double yoff;
    private final double scale;

    public PaperTransform(double xoff, double yoff, double scale) {
        this.xoff = xoff;
        this.yoff = yoff;
        this.scale = scale;
    }

    public PaperTransform(Point2D p, double scale) {
        this(p.getX(), p.getY(), scale);
    }

    public PaperTransform clone() {
        try {
            return (PaperTransform)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Point2D getOffset() {
        return new Point2D.Double(this.xoff, this.yoff);
    }

    public double getScale() {
        return this.scale;
    }

    public PaperTransform translate(double tx, double ty) {
        return new PaperTransform(this.xoff + tx, this.yoff - ty, this.scale);
    }

    public PaperTransform rotate(double theta) {
        return new RotatablePaperTransform(this.xoff, this.yoff, this.scale, theta);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PaperTransform b = (PaperTransform)obj;
        return this.xoff == b.xoff && this.yoff == b.yoff && this.scale == b.scale;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.xoff);
        bits ^= Double.doubleToLongBits(this.yoff) * 31L;
        return (int)(bits ^= Double.doubleToLongBits(this.scale) * 47L) ^ (int)(bits >> 32);
    }

    public double getXPtoD(double xp) {
        return (xp + this.xoff) * this.scale;
    }

    public double getYPtoD(double yp) {
        return (this.yoff - yp) * this.scale;
    }

    public double getXDtoP(double xd) {
        return xd / this.scale - this.xoff;
    }

    public double getYDtoP(double yd) {
        return this.yoff - yd / this.scale;
    }

    public Point2D getPtoD(Point2D p) {
        return new Point2D.Double(this.getXPtoD(p.getX()), this.getYPtoD(p.getY()));
    }

    public Point2D getDtoP(Point2D d) {
        return new Point2D.Double(this.getXDtoP(d.getX()), this.getYDtoP(d.getY()));
    }

    public Shape getPtoD(Rectangle2D p) {
        double x = this.getXPtoD(p.getX());
        double y = this.getYPtoD(p.getMaxY());
        double w = p.getWidth() * this.scale;
        double h = p.getHeight() * this.scale;
        return new Rectangle2D.Double(x, y, w, h);
    }

    public AffineTransform getTransform() {
        AffineTransform af = new AffineTransform();
        af.scale(this.scale, -this.scale);
        af.translate(this.xoff, -this.yoff);
        return af;
    }

    public String toString() {
        return "PaperTransform(" + this.xoff + "," + this.yoff + "," + this.scale + ")";
    }
}

