/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.transform;

import org.jplot2d.transform.LinearTransform;
import org.jplot2d.transform.NormalTransform;
import org.jplot2d.transform.Transform1D;
import org.jplot2d.transform.TransformType;
import org.jplot2d.util.Range;

public class LinearNormalTransform
extends NormalTransform {
    private static final TransformType type = TransformType.LINEAR;
    private final double scale;
    private final double offset;

    public LinearNormalTransform(Range ur) {
        this(ur.getStart(), ur.getEnd());
    }

    public LinearNormalTransform(double u1, double u2) {
        if (Double.isNaN(u1) || Double.isNaN(u2)) {
            throw new IllegalArgumentException("The given range (" + u1 + ", " + u2 + ") is invalid");
        }
        if (u2 - u1 == 0.0) {
            throw new IllegalArgumentException("The given range (" + u1 + ", " + u2 + ") is invalid");
        }
        this.scale = u2 - u1;
        this.offset = u1;
    }

    private LinearNormalTransform(Void v, double a, double b) {
        this.scale = a;
        this.offset = b;
    }

    @Override
    public TransformType getType() {
        return type;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public double convToNR(double w) {
        return (w - this.offset) / this.scale;
    }

    @Override
    public double convFromNR(double p) {
        return this.scale * p + this.offset;
    }

    @Override
    public NormalTransform deriveNoOffset() {
        return new LinearNormalTransform(null, this.scale, 0.0);
    }

    @Override
    public NormalTransform zoom(Range npr) {
        double b = this.offset + this.scale * npr.getStart();
        double a = this.scale * npr.getSpan();
        if (a == Double.POSITIVE_INFINITY) {
            a = Double.MAX_VALUE;
        } else if (a == Double.NEGATIVE_INFINITY) {
            a = -1.7976931348623157E308;
        }
        return new LinearNormalTransform(null, a, b);
    }

    @Override
    public NormalTransform invert() {
        return new LinearNormalTransform(null, -this.scale, this.scale + this.offset);
    }

    @Override
    public double getMinPSpan4PrecisionLimit(double pLo, double pHi, double precisionLimit) {
        double r;
        double b = this.convToNR(0.0);
        if (pLo < b && pHi > b) {
            r = 0.0;
        } else {
            double p = pLo + pHi > 2.0 * b ? pHi : pLo;
            r = precisionLimit * Math.abs(p - b);
        }
        return r;
    }

    public Range getRange4PrecisionLimit(Range range, double precisionLimit) {
        double pcsHFactor = precisionLimit / (2.0 - precisionLimit);
        double mid = (range.getStart() + range.getEnd()) / 2.0;
        double pcsHSpan = Math.abs(mid * pcsHFactor);
        if (range.getSpan() >= pcsHSpan * 2.0) {
            return range;
        }
        return new Range.Double(mid - pcsHSpan, mid + pcsHSpan);
    }

    @Override
    public Range getValueRange() {
        return new Range.Double(this.offset, this.scale + this.offset);
    }

    @Override
    public Transform1D createTransform(double d1, double d2) {
        return new LinearTransform(this.offset, this.scale, d1, d2);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LinearNormalTransform)) {
            return false;
        }
        LinearNormalTransform obj = (LinearNormalTransform)o;
        return this.scale == obj.scale && this.offset == obj.offset;
    }
}

