/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.tex;

import java.io.StringReader;
import org.jplot2d.javacc.ParseException;
import org.jplot2d.javacc.TeXMathParser;
import org.jplot2d.javacc.TokenMgrError;
import org.jplot2d.tex.MathElement;

public class TeXMathUtils {
    private static final ThreadLocal<TeXMathParser> parserTL = new ThreadLocal<TeXMathParser>(){

        @Override
        protected TeXMathParser initialValue() {
            return new TeXMathParser(new StringReader(""));
        }
    };

    public static MathElement parseText(String text) {
        MathElement model;
        if (text == null) {
            return null;
        }
        TeXMathParser parser = parserTL.get();
        parser.ReInit(new StringReader(text));
        try {
            model = parser.parse();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("the syntax of text is not correct", e);
        }
        catch (TokenMgrError e) {
            throw new IllegalArgumentException("the syntax of text is not correct", e);
        }
        return model;
    }

    public static String toString(MathElement me) {
        if (me == null) {
            return null;
        }
        return me.toString();
    }
}

