/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.tex;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.element.HAlign;
import org.jplot2d.element.VAlign;
import org.jplot2d.tex.MathElement;
import org.jplot2d.tex.MathLabelXLines;

public class MathLabel {
    private MathElement _me;
    private MathLabelXLines _mlc;
    private Font _font;
    private HAlign _halign;
    private VAlign _valign;
    private Rectangle2D bounds;

    public MathLabel(MathElement me, Font font) {
        this(me, font, VAlign.BOTTOM, HAlign.LEFT);
    }

    public MathLabel(MathElement me, Font font, VAlign valign, HAlign halign) {
        if (font == null) {
            throw new IllegalArgumentException("font cannot be null");
        }
        if (Float.isNaN(font.getSize2D())) {
            throw new IllegalArgumentException("font size2D cannot be NaN");
        }
        if (valign == null) {
            throw new IllegalArgumentException("valign cannot be null");
        }
        if (halign == null) {
            throw new IllegalArgumentException("halign cannot be null");
        }
        this._font = font;
        this._valign = valign;
        this._halign = halign;
        this._me = me;
        this._mlc = new MathLabelXLines(this._me, this._font, this._halign, this._valign);
        this._mlc.relayout(this._font.getSize2D());
        Rectangle2D dbnds = this._mlc.getBounds();
        this.bounds = new Rectangle2D.Double(dbnds.getX(), -(dbnds.getY() + dbnds.getHeight()), dbnds.getWidth(), dbnds.getHeight());
    }

    public void draw(Graphics2D g) {
        this._mlc.draw(g);
    }

    public Font getFont() {
        return this._font;
    }

    public HAlign getHAlign() {
        return this._halign;
    }

    public VAlign getVAlign() {
        return this._valign;
    }

    public MathElement getModel() {
        return this._me;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }
}

