/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.property;

import org.jplot2d.env.PropertyInfo;
import org.jplot2d.swing.proptable.property.MainProperty;
import org.jplot2d.swing.proptable.property.Property;
import org.jplot2d.swing.proptable.property.PropertyDescriptorAdapter;
import org.jplot2d.swing.proptable.property.SubProperty;
import org.jplot2d.util.Range;

public class RangeProperty
extends PropertyDescriptorAdapter<Range> {
    private Property<?>[] subProperties;
    private Double _start;
    private Double _end;

    public RangeProperty(PropertyInfo descriptor) {
        super(descriptor);
        this.initSubProperties();
    }

    @Override
    public Property<?>[] getSubProperties() {
        return this.subProperties;
    }

    @Override
    public void readFromObject(Object object) {
        super.readFromObject(object);
        if (this.getValue() != null) {
            this._start = ((Range)this.getValue()).getStart();
            this._end = ((Range)this.getValue()).getEnd();
        }
    }

    private void updateValue() {
        if (this._start != null && this._end != null) {
            this.setValue(new Range.Double(this._start, this._end));
        }
        if (this._start == null && this._end == null) {
            this.setValue(null);
        }
    }

    private void initSubProperties() {
        this.subProperties = new Property[2];
        this.subProperties[0] = new SubProperty<Double>((MainProperty)this){

            @Override
            public String getName() {
                return "start";
            }

            @Override
            public Class<Double> getType() {
                return Double.class;
            }

            @Override
            public Double getValue() {
                return RangeProperty.this._start;
            }

            @Override
            public void setValue(Double start) {
                RangeProperty.this._start = start;
                RangeProperty.this.updateValue();
            }
        };
        this.subProperties[1] = new SubProperty<Double>((MainProperty)this){

            @Override
            public String getName() {
                return "end";
            }

            @Override
            public Class<Double> getType() {
                return Double.class;
            }

            @Override
            public Double getValue() {
                return RangeProperty.this._end;
            }

            @Override
            public void setValue(Double end) {
                RangeProperty.this._end = end;
                RangeProperty.this.updateValue();
            }
        };
    }
}

