/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;
import org.jplot2d.swing.proptable.cellrenderer.FontCellRenderer;
import org.jplot2d.swing.proptable.editor.AbstractPropertyEditor;
import org.jplot2d.swing.proptable.editor.FixedButton;
import org.jplot2d.swing.proptable.editor.FontChooserDialog;

public class FontPropertyEditor
extends AbstractPropertyEditor<JPanel> {
    private FontCellRenderer label;
    private JButton button;
    private Font font;
    private FontChooserDialog fontDialog;

    public FontPropertyEditor() {
        this.editor = new JPanel(new BorderLayout(0, 0));
        ((JPanel)this.editor).add((Component)this.getLabel(), "Center");
        ((JPanel)this.editor).add((Component)this.getButton(), "East");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontPropertyEditor.this.selectFont();
            }
        });
        ((JPanel)this.editor).setOpaque(false);
    }

    private FontCellRenderer getLabel() {
        if (this.label == null) {
            this.label = new FontCellRenderer();
            this.label.setUI((LabelUI)UIManager.getUI(this.label));
            this.label.setOpaque(false);
        }
        return this.label;
    }

    private JButton getButton() {
        if (this.button == null) {
            this.button = new FixedButton();
        }
        return this.button;
    }

    @Override
    public Font getValue() {
        return this.font;
    }

    @Override
    public void setValue(Object value) {
        this.font = (Font)value;
        this.label.setValue(value);
    }

    protected void selectFont() {
        if (this.fontDialog == null) {
            Window win = SwingUtilities.getWindowAncestor(this.editor);
            this.fontDialog = new FontChooserDialog(win, true);
        }
        this.fontDialog.setFontValue(this.getValue());
        this.fontDialog.setLocationRelativeTo(this.editor);
        this.fontDialog.setVisible(true);
        if (this.fontDialog.isOK()) {
            Font oldFont = this.font;
            this.setValue(this.fontDialog.getFontValue());
            this.firePropertyChange(oldFont, this.font);
        }
    }
}

