/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.jplot2d.swing.proptable.ProperiesModel;
import org.jplot2d.swing.proptable.PropertyGroup;
import org.jplot2d.swing.proptable.PropertyTableItem;
import org.jplot2d.swing.proptable.property.MainProperty;
import org.jplot2d.swing.proptable.property.Property;

public class PropertyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("org.jplot2d");
    public static final int NAME_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    private final List<PropertyTableItem> model = new ArrayList<PropertyTableItem>();
    private final List<PropertyTableItem> publishedModel = new ArrayList<PropertyTableItem>();
    private final Object engine;
    private final ProperiesModel pm;
    private Component comp;
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MainProperty prop = (MainProperty)evt.getSource();
            try {
                prop.writeToObject(PropertyTableModel.this.engine);
            }
            catch (Throwable e) {
                JOptionPane.showMessageDialog(PropertyTableModel.this.comp, e.getMessage(), "Error", 0);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    };

    public PropertyTableModel() {
        this.engine = null;
        this.pm = null;
    }

    public PropertyTableModel(Object engine, ProperiesModel propModel) {
        if (engine == null) {
            this.engine = null;
            this.pm = null;
            return;
        }
        this.engine = engine;
        this.pm = propModel;
        for (PropertyGroup group : this.pm) {
            String category = group.getName();
            PropertyTableItem categoryItem = new PropertyTableItem(this, category, null);
            this.model.add(categoryItem);
            this.addPropertiesToModel(group, categoryItem);
        }
        for (PropertyTableItem item : this.model) {
            PropertyTableItem parent = item.getParent();
            if (parent != null && !parent.isVisible()) continue;
            this.publishedModel.add(item);
        }
        for (PropertyTableItem item : this.model) {
            Property property = item.getProperty();
            if (!(property instanceof MainProperty)) continue;
            ((MainProperty)property).readFromObject(engine);
            ((MainProperty)property).addPropertyChangeListener(this.pcl);
        }
        this.pm.checkEditable(null);
    }

    private void addPropertiesToModel(Iterable<Property<?>> localProperties, PropertyTableItem parent) {
        for (Property<?> property : localProperties) {
            PropertyTableItem propertyItem = new PropertyTableItem(this, property, parent);
            this.model.add(propertyItem);
            Property<?>[] subProperties = property.getSubProperties();
            if (subProperties == null || subProperties.length <= 0) continue;
            this.addPropertiesToModel(Arrays.asList(subProperties), propertyItem);
        }
    }

    @Override
    public int getRowCount() {
        return this.publishedModel.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        PropertyTableItem item = this.getPropertyTableItem(row);
        if (item.isProperty() && column == 1) {
            return item.getProperty().getValue();
        }
        return item;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "property";
        }
        return "value";
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        PropertyTableItem item = this.getPropertyTableItem(row);
        if (item.isProperty() && column == 1) {
            item.getProperty().setValue(value);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        PropertyTableItem item = this.getPropertyTableItem(row);
        if (item.isProperty() && column == 1) {
            return item.getProperty().isEditable();
        }
        return false;
    }

    PropertyTableItem getPropertyTableItem(int rowIndex) {
        return this.publishedModel.get(rowIndex);
    }

    public Object getEngine() {
        return this.engine;
    }

    void republish() {
        this.publishedModel.clear();
        for (PropertyTableItem item : this.model) {
            PropertyTableItem parent = item.getParent();
            if (parent != null && !parent.isVisible()) continue;
            this.publishedModel.add(item);
        }
        this.fireTableDataChanged();
    }

    public void refresh() {
        if (this.engine == null) {
            return;
        }
        for (PropertyTableItem item : this.model) {
            Property property = item.getProperty();
            if (!(property instanceof MainProperty)) continue;
            MainProperty mp = (MainProperty)property;
            mp.removePropertyChangeListener(this.pcl);
            mp.readFromObject(this.engine);
            mp.addPropertyChangeListener(this.pcl);
        }
        this.pm.checkEditable(null);
        this.fireTableDataChanged();
    }

    public void setDialogParent(Component dialogParent) {
        this.comp = dialogParent;
    }
}

