/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PropertyCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private PropertyEditor editor;
    protected JComponent editorComponent;
    protected int clickCountToStart;
    private FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(final FocusEvent e) {
            if (!(e.getSource() instanceof JTextField)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JTextField)e.getSource()).selectAll();
                }
            });
        }

        @Override
        public void focusLost(final FocusEvent e) {
            if (!(e.getSource() instanceof JTextField)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JTextField)e.getSource()).select(0, 0);
                }
            });
        }
    };
    private ActionListener commitActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertyCellEditor.this.stopCellEditing();
        }
    };
    private ActionListener cancelActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertyCellEditor.this.cancelCellEditing();
        }
    };
    private PropertyChangeListener pcListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyCellEditor.this.stopCellEditing();
        }
    };

    public PropertyCellEditor(PropertyEditor propertyEditor) {
        this.editor = propertyEditor;
        this.editorComponent = (JComponent)this.editor.getCustomEditor();
        this.clickCountToStart = 1;
        if (this.editorComponent instanceof JTextField) {
            JTextField field = (JTextField)this.editorComponent;
            field.addFocusListener(this.focusListener);
            field.addActionListener(this.commitActionListener);
            field.registerKeyboardAction(this.cancelActionListener, KeyStroke.getKeyStroke(27, 0), 0);
        }
        this.editor.addPropertyChangeListener(this.pcListener);
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getValue();
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.removeListeners();
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.removeListeners();
        this.fireEditingCanceled();
    }

    private void removeListeners() {
        if (this.editorComponent instanceof JTextField) {
            JTextField field = (JTextField)this.editorComponent;
            field.removeFocusListener(this.focusListener);
            field.removeActionListener(this.commitActionListener);
            field.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        }
        this.editor.removePropertyChangeListener(this.pcListener);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this.editorComponent instanceof JCheckBox) {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            Component c = renderer.getTableCellRendererComponent(table, value, isSelected, true, row, column);
            if (c != null) {
                this.editorComponent.setOpaque(true);
                this.editorComponent.setBackground(c.getBackground());
                if (c instanceof JComponent) {
                    this.editorComponent.setBorder(((JComponent)c).getBorder());
                }
            } else {
                this.editorComponent.setOpaque(false);
            }
        } else if (this.editorComponent instanceof JTextField) {
            JTextField field = (JTextField)this.editorComponent;
            field.setSelectedTextColor(table.getSelectionForeground());
            field.setSelectionColor(table.getSelectionBackground());
        } else {
            this.editorComponent.setForeground(table.getSelectionForeground());
            this.editorComponent.setBackground(table.getSelectionBackground());
        }
        this.editorComponent.setFont(table.getFont());
        this.editor.setValue(value);
        return this.editorComponent;
    }
}

