/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.env.RenderEnvironment;
import org.jplot2d.renderer.CacheableBlock;
import org.jplot2d.renderer.Renderer;

public class PrintRenderer
extends Renderer
implements Printable {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private static PrinterJob printerJob = PrinterJob.getPrinterJob();
    private static PageFormat pageFormat;
    private RenderEnvironment env;
    private Graphics2D g2;
    private PageFormat pf;
    private PageFitMode fitMode;

    public PrintRenderer(RenderEnvironment env) {
        this.env = env;
        this.fitMode = PageFitMode.TO_FIT;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        this.g2 = (Graphics2D)graphics;
        this.pf = pageFormat;
        this.env.exportPlot(this);
        return 0;
    }

    @Override
    public void render(ComponentEx comp, List<CacheableBlock> cacheBlockList) {
        Dimension2D size = comp.getSize();
        double dscale = comp.getPaperTransform().getScale();
        double dw = size.getWidth() * dscale;
        double dh = size.getHeight() * dscale;
        double pintScale = 1.0 / dscale;
        double dx = this.pf.getImageableX();
        double dy = this.pf.getImageableY();
        if (this.fitMode == PageFitMode.TO_FIT || this.fitMode == PageFitMode.SHRINK_TO_FIT) {
            double yf;
            double xf = this.pf.getImageableWidth() / dw;
            double fitScale = xf < (yf = this.pf.getImageableHeight() / dh) ? xf : yf;
            if (this.fitMode == PageFitMode.TO_FIT || fitScale > 1.0) {
                pintScale = fitScale;
            }
        }
        switch (this.getPageHAlign()) {
            default: {
                dx += (this.pf.getImageableWidth() - pintScale * dw) / 2.0;
                break;
            }
            case 2: {
                dx += this.pf.getImageableWidth() - pintScale * dw;
            }
            case 0: 
        }
        switch (this.getPageVAlign()) {
            default: {
                break;
            }
            case 2: {
                dy += this.pf.getImageableHeight() - pintScale * dw;
                break;
            }
            case 1: {
                dy += (this.pf.getImageableHeight() - pintScale * dh) / 2.0;
            }
        }
        this.g2.translate(dx, dy);
        this.g2.scale(pintScale, pintScale);
        for (CacheableBlock cb : cacheBlockList) {
            List<ComponentEx> sublist = cb.getSubcomps();
            for (ComponentEx subcomp : sublist) {
                subcomp.draw(this.g2);
            }
        }
    }

    private int getPageHAlign() {
        return 1;
    }

    private int getPageVAlign() {
        return 1;
    }

    public static void pageDialog() {
        if (pageFormat == null) {
            pageFormat = printerJob.defaultPage();
        }
        pageFormat = printerJob.pageDialog(pageFormat);
    }

    public static void printDialog(RenderEnvironment env) throws PrinterException {
        if (pageFormat == null) {
            pageFormat = printerJob.defaultPage();
            pageFormat = printerJob.pageDialog(pageFormat);
        }
        printerJob.setPrintable(new PrintRenderer(env), pageFormat);
        if (printerJob.printDialog()) {
            printerJob.print();
        }
    }

    public static enum PageFitMode {
        TO_FIT,
        DEFAULT_SCALE,
        SHRINK_TO_FIT;

    }
}

