/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.demo;

import org.jplot2d.data.ArrayPair;
import org.jplot2d.data.XYGraphData;
import org.jplot2d.element.Axis;
import org.jplot2d.element.ElementFactory;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Plot;
import org.jplot2d.element.Title;
import org.jplot2d.element.XYGraph;
import org.jplot2d.sizing.AutoPackSizeMode;
import org.jplot2d.swing.JPlot2DFrame;
import org.jplot2d.transform.ReciprocalAxisTickTransform;

public class ReciprocalAxisDemo {
    public static void main(String[] args) {
        Plot plot = ElementFactory.getInstance().createPlot();
        plot.setSizeMode(new AutoPackSizeMode());
        Title title = ElementFactory.getInstance().createTitle("Reciprocal Axis Demo");
        title.setFontScale(2.0f);
        plot.addTitle(title);
        JPlot2DFrame frame = new JPlot2DFrame(plot);
        frame.setSize(640, 480);
        frame.setVisible(true);
        Axis xaxis = ElementFactory.getInstance().createAxis();
        xaxis.getTitle().setText("x axis");
        plot.addXAxis(xaxis);
        Axis yaxis = ElementFactory.getInstance().createAxis();
        yaxis.getTitle().setText("y axis");
        plot.addYAxis(yaxis);
        Axis xaux = ElementFactory.getInstance().createAxis();
        xaux.getTitle().setText("1/x axis");
        plot.addXAxis(xaux);
        xaux.getTickManager().setAxisTransform(xaxis.getTickManager().getAxisTransform());
        xaux.getTickManager().setTickTransform(new ReciprocalAxisTickTransform(2.0));
        XYGraphData graphData = new XYGraphData(new ArrayPair(new double[]{0.0, 2.0, 4.0, 6.0, 8.0, 10.0}, new double[]{0.0, 0.6, 1.0, 0.4, 0.5, 0.8}));
        XYGraph graph = ElementFactory.getInstance().createXYGraph(graphData);
        Layer layer0 = ElementFactory.getInstance().createLayer();
        layer0.addGraph(graph);
        plot.addLayer(layer0, xaxis, yaxis);
    }
}

