/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.demo;

import org.jplot2d.element.Axis;
import org.jplot2d.element.ElementFactory;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Plot;
import org.jplot2d.layout.BoundsConstraint;
import org.jplot2d.layout.OverlayLayoutDirector;
import org.jplot2d.sizing.FillContainerSizeMode;
import org.jplot2d.swing.JPlot2DFrame;
import org.jplot2d.util.Insets2D;

public class OverlayLayoutDemo {
    public static void main(String[] args) {
        ElementFactory ef = ElementFactory.getInstance();
        Plot plot = ef.createPlot();
        plot.setSizeMode(new FillContainerSizeMode(1.0));
        plot.setLayoutDirector(new OverlayLayoutDirector());
        JPlot2DFrame frame = new JPlot2DFrame(plot);
        frame.setSize(640, 480);
        frame.setVisible(true);
        Axis[] xaxes = ef.createAxes(2);
        Axis[] yaxes = ef.createAxes(2);
        xaxes[0].getTitle().setText("x axis");
        yaxes[0].getTitle().setText("y axis");
        plot.addXAxes(xaxes);
        plot.addYAxes(yaxes);
        Layer layer = ef.createLayer(ef.createXYGraph(new double[]{0.0, 0.1, 0.2}, new double[]{0.0, 0.1, 0.4}, "line A"));
        plot.addLayer(layer, xaxes[0], yaxes[0]);
        Plot sp1 = ef.createSubplot();
        Layer nestLayer = ef.createLayer(ef.createXYGraph(new double[]{0.0, 0.1, 0.2}, new double[]{0.0, 0.1, 0.4}, "line B"));
        plot.addSubplot(sp1, new BoundsConstraint(new Insets2D.Double(0.0, 0.0, 0.0, 0.0), new Insets2D.Double(0.05, 0.05, 0.45, 0.45)));
        sp1.setLocation(80.0, 250.0);
        sp1.setSize(300.0, 200.0);
        Axis[] p1x = ef.createAxes(2);
        Axis[] p1y = ef.createAxes(2);
        p1x[0].getTitle().setText("x axis");
        p1y[0].getTitle().setText("y axis");
        p1x[1].setTickVisible(false);
        p1x[1].setLabelVisible(false);
        p1y[1].setTickVisible(false);
        p1y[1].setLabelVisible(false);
        sp1.addXAxes(p1x);
        sp1.addYAxes(p1y);
        sp1.addLayer(nestLayer, p1x[0], p1y[0]);
    }
}

