/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.demo;

import java.awt.Dimension;
import javax.swing.SwingUtilities;
import org.jplot2d.data.ArrayPair;
import org.jplot2d.data.XYGraphData;
import org.jplot2d.element.Axis;
import org.jplot2d.element.CoordinateAnnotation;
import org.jplot2d.element.ElementFactory;
import org.jplot2d.element.HLineAnnotation;
import org.jplot2d.element.HStripAnnotation;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Plot;
import org.jplot2d.element.RectangleAnnotation;
import org.jplot2d.element.SymbolAnnotation;
import org.jplot2d.element.Title;
import org.jplot2d.element.VLineAnnotation;
import org.jplot2d.element.VStripAnnotation;
import org.jplot2d.element.XYGraph;
import org.jplot2d.sizing.AutoPackSizeMode;
import org.jplot2d.swing.JPlot2DFrame;
import org.jplot2d.util.SymbolShape;

public class DevDemo {
    public static void main(String[] args) throws InterruptedException {
        final Plot plot = ElementFactory.getInstance().createPlot();
        plot.setSizeMode(new AutoPackSizeMode());
        Title title = ElementFactory.getInstance().createTitle("Title");
        title.setFontScale(2.0f);
        plot.addTitle(title);
        Axis[] xaxes = ElementFactory.getInstance().createAxes(2);
        xaxes[0].getTitle().setText("x axis");
        plot.addXAxes(xaxes);
        Axis[] yaxes = ElementFactory.getInstance().createAxes(2);
        yaxes[0].getTitle().setText("y axis");
        plot.addYAxes(yaxes);
        XYGraphData graph = new XYGraphData(new ArrayPair(new double[]{0.0, 0.1, 0.2}, new double[]{0.0, 0.1, 0.4}), null, new ArrayPair(new double[]{0.01, 0.01, 0.01}, new double[]{0.01, 0.01, 0.01}));
        XYGraph gp = ElementFactory.getInstance().createXYGraph(graph, "asdf");
        System.out.print(gp.getSymbolColor());
        Layer layer0 = ElementFactory.getInstance().createLayer();
        layer0.addGraph(gp);
        gp.setSymbolVisible(true);
        gp.setSymbolShape(SymbolShape.CIRCLE);
        gp.setSymbolSize(14.0f);
        SymbolAnnotation sm = ElementFactory.getInstance().createSymbolAnnotation(0.06, 0.12, SymbolShape.VCROSS, "marker");
        sm.setAngle(60.0);
        layer0.addAnnotation(sm);
        CoordinateAnnotation ca = ElementFactory.getInstance().createCoordinateAnnotation(0.0, 0.3, SymbolShape.VCROSS);
        layer0.addAnnotation(ca);
        HLineAnnotation hlm = ElementFactory.getInstance().createHLineAnnotation(0.1);
        layer0.addAnnotation(hlm);
        VLineAnnotation vlm = ElementFactory.getInstance().createVLineAnnotation(0.1);
        layer0.addAnnotation(vlm);
        HStripAnnotation hsm = ElementFactory.getInstance().createHStripAnnotation(0.15, 0.15);
        layer0.addAnnotation(hsm);
        VStripAnnotation vsm = ElementFactory.getInstance().createVStripAnnotation(0.13, 0.15);
        layer0.addAnnotation(vsm);
        RectangleAnnotation ra = ElementFactory.getInstance().createRectangleAnnotation(0.0, 0.0, 0.05, 0.05);
        layer0.addAnnotation(ra);
        plot.addLayer(layer0);
        layer0.setAxesTransform(xaxes[0].getTickManager().getAxisTransform(), yaxes[0].getTickManager().getAxisTransform());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPlot2DFrame frame = new JPlot2DFrame(plot);
                frame.getPlotComponent().setPreferredSize(new Dimension(640, 480));
                frame.pack();
                frame.setVisible(true);
            }
        });
        Thread.sleep(5000L);
        sm.setSymbolScale(2.0f);
    }
}

