/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.demo;

import java.awt.Color;
import org.jplot2d.element.Axis;
import org.jplot2d.element.ElementFactory;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Plot;
import org.jplot2d.element.Title;
import org.jplot2d.element.TitlePosition;
import org.jplot2d.sizing.AutoPackSizeMode;
import org.jplot2d.swing.JPlot2DFrame;

public class AutoPackSizeDemo {
    public static void main(String[] args) {
        ElementFactory ef = ElementFactory.getInstance();
        Plot plot = ef.createPlot();
        plot.setSizeMode(new AutoPackSizeMode());
        Title title = ef.createTitle("Custom Title");
        title.setFontScale(2.0f);
        plot.addTitle(title);
        Title subtitle = ef.createTitle("Custom Subtitle");
        subtitle.setFontScale(1.2f);
        plot.addTitle(subtitle);
        Title copyRight = ef.createTitle("\u00a9 2012 jplot2d project (LGPL)");
        copyRight.setFontScale(1.0f);
        copyRight.setColor(Color.BLUE.darker());
        copyRight.setPosition(TitlePosition.BOTTOMRIGHT);
        plot.addTitle(copyRight);
        JPlot2DFrame frame = new JPlot2DFrame(plot);
        frame.setSize(640, 480);
        frame.setVisible(true);
        Axis xaxis = ef.createAxis();
        Axis yaxis = ef.createAxis();
        xaxis.getTitle().setText("x axis");
        plot.addXAxis(xaxis);
        yaxis.getTitle().setText("y axis");
        plot.addYAxis(yaxis);
        Layer layer0 = ef.createLayer(ef.createXYGraph(new double[]{0.0, 0.1, 0.2}, new double[]{0.0, 0.1, 0.4}, null));
        Layer layer1 = ef.createLayer(ef.createXYGraph(new double[]{0.0, 0.2, 0.4}, new double[]{0.0, 0.3, 0.4}, "lineB"));
        plot.addLayer(layer0, xaxis, yaxis);
        plot.addLayer(layer1, xaxis, yaxis);
    }
}

