/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jplot2d.element.Plot;
import org.jplot2d.env.RenderEnvironment;
import org.jplot2d.interaction.InteractionManager;
import org.jplot2d.interaction.MousePreference;
import org.jplot2d.interaction.PlotDefaultMousePreference;
import org.jplot2d.interaction.PlotInteractionManager;
import org.jplot2d.notice.DefaultNotifier;
import org.jplot2d.renderer.AsyncImageRenderer;
import org.jplot2d.renderer.GraphicsConfigurationCompatibleImageFactory;
import org.jplot2d.renderer.ImageRenderer;
import org.jplot2d.renderer.RenderingFinishedEvent;
import org.jplot2d.renderer.RenderingFinishedListener;
import org.jplot2d.swing.ImageRendererFactory;
import org.jplot2d.swing.interaction.InteractionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPlot2DComponent
extends JComponent
implements HierarchyListener,
RenderingFinishedListener {
    private static final long serialVersionUID = 1L;
    static Logger logger = LoggerFactory.getLogger((String)"org.jplot2d.swing");
    private final RenderEnvironment env;
    private Color bgColor = Color.WHITE;
    private ImageRendererFactory rendererFactory;
    private ImageRenderer r;
    private Object renderLock = new Object();
    private long ifsn = -1L;
    private Object fsnLock = new Object();
    private volatile BufferedImage image;
    private int xoff;
    private int yoff;
    private InteractionManager imanager;
    private final InteractionListener ial;
    private boolean iaEnabled;

    public JPlot2DComponent(Plot plot) {
        this(plot, true);
    }

    public JPlot2DComponent(Plot plot, boolean threadSafe) {
        this(JPlot2DComponent.createRenderEnvironment(threadSafe));
        this.env.setPlot(plot, new DefaultNotifier(this));
    }

    private static RenderEnvironment createRenderEnvironment(boolean threadSafe) {
        RenderEnvironment env = new RenderEnvironment(threadSafe);
        return env;
    }

    public JPlot2DComponent(RenderEnvironment env) {
        this.env = env;
        this.rendererFactory = new DefaultImageRendererFactory(this);
        this.setBackground(Color.GRAY);
        this.setOpaque(true);
        this.addHierarchyListener(this);
        this.imanager = this.createInteractionManager();
        this.ial = new InteractionListener(this, this.imanager, env);
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.setInteractionEnabled(true);
    }

    public RenderEnvironment getRenderEnvironment() {
        return this.env;
    }

    public Color getPlotBackground() {
        return this.bgColor;
    }

    public void setPlotBackground(Color bgColor) {
        this.bgColor = bgColor;
        this.replaceRenderer();
    }

    public ImageRendererFactory getImageRendererFactory() {
        return this.rendererFactory;
    }

    public void setImageRendererFactory(ImageRendererFactory rendererFactory) {
        this.rendererFactory = rendererFactory;
        this.replaceRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceRenderer() {
        Object object = this.renderLock;
        synchronized (object) {
            if (this.r != null) {
                this.env.removeRenderer(this.r);
                this.r = this.createAndSetRenderer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageRenderer createAndSetRenderer() {
        Object object = this.fsnLock;
        synchronized (object) {
            this.ifsn = -1L;
        }
        ImageRenderer ir = this.rendererFactory.createImageRenderer();
        ir.addRenderingFinishedListener(this);
        this.env.addRenderer(ir);
        this.env.exportPlot(ir);
        return ir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hierarchyChanged(HierarchyEvent event) {
        if ((event.getChangeFlags() & 2L) != 0L) {
            Object object = this.renderLock;
            synchronized (object) {
                if (this.isDisplayable()) {
                    this.r = this.createAndSetRenderer();
                } else {
                    this.env.removeRenderer(this.r);
                    this.r = null;
                }
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.env.getPlot().setContainerSize(new Dimension(width, height));
    }

    @Override
    public void paintComponent(Graphics g) {
        ((Graphics2D)g).setBackground(this.getBackground());
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            int width = this.image.getWidth();
            int height = this.image.getHeight();
            this.xoff = (this.getWidth() - width) / 2;
            this.yoff = (this.getHeight() - height) / 2;
            g.drawImage(this.image, this.xoff, this.yoff, this);
            this.ial.draw((Graphics2D)g);
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getImageOffsetX() {
        return this.xoff;
    }

    public int getImageOffsetY() {
        return this.yoff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderingFinished(RenderingFinishedEvent event) {
        boolean ok;
        long sn = event.getSN();
        Object object = this.fsnLock;
        synchronized (object) {
            if (sn > this.ifsn) {
                ok = true;
                this.ifsn = sn;
            } else {
                ok = false;
            }
        }
        if (!ok) {
            logger.trace("[R] Rendering finished in wrong order, drop R." + sn + " Current result is " + this.ifsn);
            return;
        }
        this.image = (BufferedImage)event.getResult();
        this.repaint();
    }

    protected InteractionManager createInteractionManager() {
        PlotInteractionManager result = PlotInteractionManager.getInstance();
        result.setMousePreference(PlotDefaultMousePreference.getInstance());
        return result;
    }

    public void setMousePreference(MousePreference prefs) {
        this.imanager.setMousePreference(prefs);
    }

    public void setInteractionEnabled(boolean enabled) {
        if (this.iaEnabled == enabled) {
            return;
        }
        if (enabled) {
            this.addKeyListener(this.ial);
            this.addMouseListener(this.ial);
            this.addMouseMotionListener(this.ial);
            this.addMouseWheelListener(this.ial);
        } else {
            this.removeKeyListener(this.ial);
            this.removeMouseListener(this.ial);
            this.removeMouseMotionListener(this.ial);
            this.removeMouseWheelListener(this.ial);
        }
        this.iaEnabled = enabled;
    }

    public static class DefaultImageRendererFactory
    implements ImageRendererFactory {
        private final JPlot2DComponent comp;

        public DefaultImageRendererFactory(JPlot2DComponent comp) {
            this.comp = comp;
        }

        @Override
        public AsyncImageRenderer createImageRenderer() {
            return new AsyncImageRenderer(new GraphicsConfigurationCompatibleImageFactory(this.comp.getGraphicsConfiguration(), this.comp.getPlotBackground()));
        }
    }
}

