/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.renderer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.renderer.CacheableBlock;
import org.jplot2d.renderer.Renderer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGZExporter
extends Renderer {
    private final OutputStream os;
    private String fname;

    public SVGZExporter(String pathname) throws FileNotFoundException {
        this(new File(pathname));
        this.fname = pathname;
    }

    public SVGZExporter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public SVGZExporter(OutputStream out) {
        this.os = new BufferedOutputStream(out);
    }

    @Override
    public void render(ComponentEx comp, List<CacheableBlock> cacheBlockList) {
        Dimension size = SVGZExporter.getDeviceBounds(comp).getSize();
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGraphics2D g = new SVGGraphics2D(document);
        g.setSVGCanvasSize(size);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (CacheableBlock cb : cacheBlockList) {
            List<ComponentEx> sublist = cb.getSubcomps();
            for (ComponentEx subcomp : sublist) {
                subcomp.draw((Graphics2D)g);
            }
        }
        g.dispose();
        try {
            FileOutputStream fos = new FileOutputStream(this.fname);
            GZIPOutputStream gzipOS = new GZIPOutputStream(fos);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)gzipOS, "UTF-8");
            g.stream((Writer)out, true);
            gzipOS.flush();
            gzipOS.close();
        }
        catch (IOException a) {
            System.err.println("Error while exporting to SVGZ");
        }
    }
}

