/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.renderer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.renderer.CacheableBlock;
import org.jplot2d.renderer.Renderer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGExporter
extends Renderer {
    private final OutputStream os;

    public SVGExporter(String pathname) throws FileNotFoundException {
        this(new File(pathname));
    }

    public SVGExporter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public SVGExporter(OutputStream out) {
        this.os = new BufferedOutputStream(out);
    }

    @Override
    public void render(ComponentEx comp, List<CacheableBlock> cacheBlockList) {
        Dimension size = SVGExporter.getDeviceBounds(comp).getSize();
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGraphics2D g = new SVGGraphics2D(document);
        g.setSVGCanvasSize(size);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (CacheableBlock cb : cacheBlockList) {
            List<ComponentEx> sublist = cb.getSubcomps();
            for (ComponentEx subcomp : sublist) {
                subcomp.draw((Graphics2D)g);
            }
        }
        g.dispose();
        try {
            OutputStreamWriter out = new OutputStreamWriter(this.os, "UTF-8");
            g.stream((Writer)out, true);
            this.os.flush();
            this.os.close();
        }
        catch (IOException a) {
            System.err.println("Error while exporting to SVGZ");
        }
    }
}

