/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.renderer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.jplot2d.renderer.BufferedImageFactory;
import org.jplot2d.renderer.ImageExporter;
import org.jplot2d.renderer.ImageFactory;

public class PngStreamExporter
extends ImageExporter {
    private static final ImageFactory INT_RGB_IMAGEFACTORY = new BufferedImageFactory(1, Color.WHITE);
    private final OutputStream out;

    public PngStreamExporter(OutputStream out) {
        this(INT_RGB_IMAGEFACTORY, out);
    }

    public PngStreamExporter(ImageFactory imageFactory, OutputStream out) {
        super(imageFactory);
        this.out = out;
    }

    protected void fireRenderingFinished(int sn, BufferedImage img) {
        super.fireRenderingFinished(sn, img);
        try {
            ImageIO.write((RenderedImage)img, "PNG", this.out);
        }
        catch (IOException e) {
            throw new RuntimeException("Png out I/O exception", e);
        }
    }
}

